/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.policy;

import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.policy.PolicyException;
import java.net.URI;
import java.net.URISyntaxException;

public class PolicyEnforcer {
    private final URI mpacBaseUrl;
    private final boolean pluginUploadEnabled;
    private static final String PLUGIN_UPLOAD_ENABLED_PROP = "upm.plugin.upload.enabled";

    public PolicyEnforcer() {
        try {
            this.mpacBaseUrl = new URI(Sys.getMpacBaseUrl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse MPAC base URL", e);
        }
        this.pluginUploadEnabled = Boolean.getBoolean(PLUGIN_UPLOAD_ENABLED_PROP) || Sys.isDevModeEnabled();
    }

    public void checkCanInstallPluginByUpload() {
        if (!this.isPluginUploadEnabled()) {
            throw new PolicyException("Plugins cannot be installed via upload");
        }
    }

    public void checkCanInstallPluginFromUri(URI uri) {
        if (!this.isMpacUri(uri) && !this.isPluginUploadEnabled()) {
            throw new PolicyException("Plugins can only be installed from Atlassian Marketplace");
        }
    }

    public boolean isPluginUploadEnabled() {
        return this.pluginUploadEnabled;
    }

    private boolean isMpacUri(URI uri) {
        return this.mpacBaseUrl.getScheme().equals(uri.getScheme()) && this.mpacBaseUrl.getHost().equalsIgnoreCase(uri.getHost());
    }
}

