UPM.define('UpmMessageView', ['jquery', 'underscore', 'BaseView', 'UpmMessageTemplate'], function($jq, _, BaseView, upmMessageTemplate) {

    return BaseView.extend({

        template: upmMessageTemplate,

        events: {
            "click .upm-icon-close": "_onCloseClicked"
        },

        _postInitialize: function() {
                var msg = $jq(".upm-message-container").text();
                var trimmedMsg = $jq.trim(msg);
                if(trimmedMsg===this.model.getMessage() || trimmedMsg.indexOf(this.model.getMessage())!=-1){
                    $jq(".upm-message-container").empty();
                }
            },

        _postRender: function() {
            var closeAfter = this.model.getCloseAfter();
            if (closeAfter > 0) {
                _.delay(_.bind(this._close, this), closeAfter * 1000);
            }

            if (this.model.getClassName()) {
                this.$el.addClass(this.model.getClassName());
            }
        },

        _onCloseClicked: function(e) {
            e.preventDefault();
            this._close();
        },

        _close: function() {
            this.$el.fadeOut(500, _.bind(function() {
                this.$el.remove();
            }, this));
        }

    });
});