UPM.define("AuditLogEntryView", ["BaseCollectionItemView"], function(BaseCollectionItemView) {

    return BaseCollectionItemView.extend({

        template: "#upm-log-table-template",

        /**
         * Formats the Audit Log Entry model's data for display.
         *
         * Formats the dateUpdated property.
         *
         * @returns {Object} The formatted data.
         * @private
         */
        _getData: function() {
            var model = this.model.toJSON();
            var locale = AJS.Meta ? AJS.Meta.get('user-locale').replace('_', '-') : navigator.language;
            var date = new Date(model.dateUpdated);
            model.dateUpdated = new Intl.DateTimeFormat(locale, {
                year: 'numeric',
                month: 'short',
                day: 'numeric',
                hour: 'numeric',
                minute: 'numeric',
                second: 'numeric'
            }).format(date);

            model.epoch = date.getTime();

            return model;
        }

    });
});
