/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.topology;

import com.atlassian.marketplace.client.http.HttpConfiguration;
import com.atlassian.marketplace.client.impl.CommonsHttpTransport;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.pac.MarketplaceClientConfiguration;
import com.atlassian.upm.jwt.UpmJwtToken;
import com.atlassian.upm.rest.representations.InstanceTopologyRepresentation;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.atlassian.upm.topology.InstanceTopology;
import com.atlassian.upm.topology.InstanceTopologyFactory;
import com.atlassian.upm.topology.InstanceTopologyService;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceTopologyServiceImpl
implements InstanceTopologyService {
    private static final Logger log = LoggerFactory.getLogger((String)InstanceTopologyServiceImpl.class.getName());
    private static final int CONNECT_TIMEOUT_MILLIS = 10000;
    private static final int READ_TIMEOUT_MILLIS = 10000;
    private final InstanceTopologyFactory topologyFactory;
    private final UpmRepresentationFactory representationFactory;
    private final SysPersisted sysPersisted;
    private final HttpClient httpClient;
    private final ObjectMapper mapper;

    public InstanceTopologyServiceImpl(InstanceTopologyFactory topologyFactory, UpmRepresentationFactory representationFactory, SysPersisted sysPersisted) {
        this.topologyFactory = Objects.requireNonNull(topologyFactory, "topologyFactory");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.sysPersisted = Objects.requireNonNull(sysPersisted, "sysPersisted");
        HttpConfiguration config = MarketplaceClientConfiguration.httpConfigurationFromSystemProperties().connectTimeoutMillis(10000).readTimeoutMillis(10000).build();
        this.httpClient = CommonsHttpTransport.createHttpClient(config, UpmFugueConverters.fugueNone(URI.class));
        this.mapper = new ObjectMapper((JsonFactory)new MappingJsonFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendInstanceTopologyData() {
        if (!this.sysPersisted.is(UpmSettings.PAC_DISABLED)) {
            for (InstanceTopology topo : this.topologyFactory.generateTopology()) {
                InstanceTopologyRepresentation entity = this.representationFactory.createInstanceTopologyRepresentation(topo);
                HttpResponse response = null;
                try {
                    if (topo.getProductLicenses().isEmpty()) continue;
                    HttpPost post = new HttpPost(InstanceTopologyServiceImpl.getTopologyUri(this.topologyFactory.generateJwtToken(topo)));
                    post.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)entity), ContentType.APPLICATION_JSON));
                    response = this.httpClient.execute((HttpUriRequest)post);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        log.info("Successful topology phone-home attempt.");
                        continue;
                    }
                    log.info("Unsuccessful topology phone-home attempt: " + response.getStatusLine().getStatusCode());
                }
                catch (IOException e) {
                    log.info("Error sending instance topology data", (Throwable)e);
                }
                finally {
                    if (response != null && response.getEntity() != null) {
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    }
                }
            }
        }
    }

    private static URI getTopologyUri(UpmJwtToken jwtToken) {
        return URI.create(Sys.getInstanceTopologyBaseUrl() + "/signed/" + jwtToken.getToken());
    }
}

