/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.upm.core.ApplicationPluginsManager;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.RequestContext;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.license.PluginLicenses;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.pac.AvailableAddonWithVersionBase;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.text.Collator;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/purchased/available")
public class PurchasedPluginCollectionResource {
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;
    private final LocaleResolver localeResolver;
    private final PacClient pacClient;
    private final PluginRetriever pluginRetriever;
    private final PluginLicenseRepository licenseRepository;
    private final ApplicationPluginsManager applicationPluginsManager;
    private static final Function<AvailableAddonWithVersionBase, String> pluginSummaryToKey = a -> a.getAddonBase().getKey();

    public PurchasedPluginCollectionResource(UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer, LocaleResolver localeResolver, PacClient pacClient, PluginRetriever pluginRetriever, PluginLicenseRepository licenseRepository, ApplicationPluginsManager applicationPluginsManager) {
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.localeResolver = (LocaleResolver)Preconditions.checkNotNull((Object)localeResolver, (Object)"localeResolver");
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.applicationPluginsManager = (ApplicationPluginsManager)Preconditions.checkNotNull((Object)applicationPluginsManager, (Object)"licensingUsageVerifier");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get(@Context HttpServletRequest request) {
        this.permissionEnforcer.enforcePermission(Permission.GET_PURCHASED_PLUGINS);
        Set<String> applicationPluginKeys = this.applicationPluginsManager.getApplicationRelatedPlugins(StreamSupport.stream(this.pluginRetriever.getPlugins().spliterator(), false).map(arg_0 -> Plugins.toPlugPlugin.apply(arg_0)).collect(Collectors.toList())).keySet();
        Predicate isApplicationPluginLicense = Predicates.compose((Predicate)Predicates.in(applicationPluginKeys), PluginLicenses.licensePluginKey());
        ImmutableList licenses = ImmutableList.copyOf((Collection)StreamSupport.stream(this.licenseRepository.getPluginLicenses().spliterator(), false).filter(PluginLicenses.isEvaluation().negate()).filter(PluginLicenses.isEmbeddedWithinHostLicense().negate()).filter(isApplicationPluginLicense.negate()).collect(Collectors.toList()));
        ImmutableMap licenseMap = Maps.uniqueIndex((Iterable)licenses, PluginLicenses.licensePluginKey());
        boolean pacUnreachable = !this.pacClient.isPacReachable();
        ImmutableList plugins = ImmutableList.copyOf(this.pacClient.getPlugins(licenseMap.keySet()));
        Ordering ordering = this.orderingWithInstalledPluginsLast().compound(this.orderingByPluginName(this.localeResolver.getLocale(request)));
        ImmutableSet compatiblePluginKeysReturnedByMpac = ImmutableSet.copyOf((Collection)StreamSupport.stream(plugins.spliterator(), false).map(pluginSummaryToKey).collect(Collectors.toList()));
        Sets.SetView incompatibleOrUnknownPluginKeys = Sets.difference(licenseMap.keySet(), (Set)compatiblePluginKeysReturnedByMpac);
        ImmutableList incompatiblePlugins = ImmutableList.copyOf(this.pacClient.getLatestVersionOfPlugins((Iterable<String>)incompatibleOrUnknownPluginKeys));
        ImmutableSet incompatiblePluginKeysReturnedByMpac = ImmutableSet.copyOf((Collection)StreamSupport.stream(incompatiblePlugins.spliterator(), false).map(pluginSummaryToKey).collect(Collectors.toList()));
        Sets.SetView unknownPluginKeys = Sets.difference((Set)incompatibleOrUnknownPluginKeys, (Set)incompatiblePluginKeysReturnedByMpac);
        return Response.ok((Object)this.representationFactory.createPurchasedPluginCollectionRepresentation(this.localeResolver.getLocale(request), ordering.sortedCopy((Iterable)plugins), (Iterable<AvailableAddonWithVersionBase>)incompatiblePlugins, (Iterable<String>)unknownPluginKeys, new RequestContext(request).pacUnreachable(pacUnreachable))).build();
    }

    private Ordering<AvailableAddonWithVersionBase> orderingWithInstalledPluginsLast() {
        return new Ordering<AvailableAddonWithVersionBase>(){

            public int compare(AvailableAddonWithVersionBase a, AvailableAddonWithVersionBase b) {
                boolean bInstalled;
                boolean aInstalled = PurchasedPluginCollectionResource.this.pluginRetriever.isPluginInstalled(a.getAddonBase().getKey());
                if (aInstalled == (bInstalled = PurchasedPluginCollectionResource.this.pluginRetriever.isPluginInstalled(b.getAddonBase().getKey()))) {
                    return 0;
                }
                return aInstalled ? 1 : -1;
            }
        };
    }

    private Ordering<AvailableAddonWithVersionBase> orderingByPluginName(Locale locale) {
        final Collator collator = Collator.getInstance(locale);
        return new Ordering<AvailableAddonWithVersionBase>(){

            public int compare(AvailableAddonWithVersionBase a, AvailableAddonWithVersionBase b) {
                return collator.compare(a.getAddonBase().getName(), b.getAddonBase().getName());
            }
        };
    }
}

