/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.RequestContext;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.token.TokenManager;
import com.atlassian.upm.pac.AvailableAddonWithVersion;
import com.atlassian.upm.pac.IncompatiblePluginData;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/installed-marketplace")
public class InstalledMarketplacePluginCollectionResource {
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;
    private final PluginRetriever pluginRetriever;
    private final LocaleResolver localeResolver;
    private final TokenManager tokenManager;
    private final UserManager userManager;
    private final PacClient pacClient;
    private final UpmInformation upm;
    private static final Logger log = LoggerFactory.getLogger(InstalledMarketplacePluginCollectionResource.class);

    public InstalledMarketplacePluginCollectionResource(UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer, PluginRetriever pluginRetriever, LocaleResolver localeResolver, TokenManager tokenManager, UserManager userManager, PacClient pacClient, UpmInformation upm) {
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.localeResolver = (LocaleResolver)Preconditions.checkNotNull((Object)localeResolver, (Object)"localeResolver");
        this.tokenManager = (TokenManager)Preconditions.checkNotNull((Object)tokenManager, (Object)"tokenManager");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
        this.upm = (UpmInformation)Preconditions.checkNotNull((Object)upm, (Object)"upm");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get(@Context HttpServletRequest request, @QueryParam(value="updates") @DefaultValue(value="false") boolean withUpdates) {
        this.permissionEnforcer.enforcePermission(Permission.GET_INSTALLED_PLUGINS);
        boolean pacUnreachable = !this.pacClient.isPacReachable();
        Object updates = ImmutableList.of();
        Object incompatibles = ImmutableList.of();
        String upmUpdateVersion = null;
        if (withUpdates) {
            try {
                updates = this.pacClient.getUpdates();
                Iterator iterator = updates.iterator();
                block4: while (iterator.hasNext()) {
                    AvailableAddonWithVersion update = (AvailableAddonWithVersion)iterator.next();
                    if (!this.upm.getPluginKey().equals(update.getAddon().getKey())) continue;
                    for (URI binaryUri : update.getVersion().getArtifactUri()) {
                        if (!this.permissionEnforcer.hasInProcessInstallationFromUriPermission(binaryUri)) continue;
                        upmUpdateVersion = (String)update.getVersion().getName().getOrElse((Object)"");
                        continue block4;
                    }
                }
            }
            catch (MpacException e) {
                log.warn("Failed to get plugin updates: " + e.getMessage());
                log.debug(e.getMessage(), (Throwable)e);
                pacUnreachable = true;
            }
            if (!pacUnreachable && Sys.isIncompatiblePluginCheckEnabled()) {
                try {
                    incompatibles = this.pacClient.getIncompatiblePlugins((Iterable<String>)ImmutableList.of());
                }
                catch (MpacException e) {
                    log.warn("Failed to get incompatible plugins: " + e.getMessage());
                    log.debug(e.getMessage(), (Throwable)e);
                    pacUnreachable = true;
                }
            }
        }
        Iterable<Plugin> plugins = this.pluginRetriever.getPlugins(Iterables.transform((Iterable)updates, AvailableAddonWithVersion.toAddon()));
        return Response.ok((Object)this.representationFactory.createInstalledMarketplacePluginCollectionRepresentation(this.localeResolver.getLocale(request), plugins, (Iterable<AvailableAddonWithVersion>)updates, (Iterable<IncompatiblePluginData>)incompatibles, new RequestContext(request).pacUnreachable(pacUnreachable), upmUpdateVersion)).header("upm-token", (Object)this.tokenManager.getTokenForUser(this.userManager.getRemoteUserKey())).build();
    }
}

