/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.PacClient;
import com.google.common.base.Preconditions;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/categories")
@WebSudoNotRequired
public class CategoryCollectionResource {
    private final PacClient client;
    private final PermissionEnforcer permissionEnforcer;
    private static final Logger log = LoggerFactory.getLogger(CategoryCollectionResource.class);

    public CategoryCollectionResource(PacClient client, PermissionEnforcer permissionEnforcer) {
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.client = (PacClient)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.categories+json"})
    public Response get() {
        this.permissionEnforcer.enforcePermission(Permission.GET_AVAILABLE_PLUGINS);
        try {
            return Response.ok(this.client.getCategories()).build();
        }
        catch (MpacException e) {
            log.warn("Failed to get categories", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

