/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.request;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.core.impl.NamespacedPluginSettings;
import com.atlassian.upm.impl.Locks;
import com.atlassian.upm.request.PluginRequest;
import com.atlassian.upm.request.PluginRequestFactory;
import com.atlassian.upm.request.PluginRequestStore;
import com.atlassian.upm.request.rest.representations.PluginRequestRepresentation;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.atlassian.upm.rest.representations.UpmLinkBuilder;
import com.atlassian.upm.schedule.UpmScheduler;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSettingsPluginRequestStore
implements PluginRequestStore {
    public static final String KEY_PREFIX = PluginSettingsPluginRequestStore.class.getName() + ":requests:";
    private static final String REQUEST_KEY = "requests_v2";
    private static final Logger log = LoggerFactory.getLogger((String)PluginSettingsPluginRequestStore.class.getName());
    private final ClusterLock lock;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginRequestFactory requestFactory;
    private final UpmLinkBuilder linkBuilder;
    private final UpmUriBuilder uriBuilder;
    private final UserManager userManager;
    private final UpmScheduler scheduler;
    private final ObjectMapper mapper;
    private static Comparator<Collection<PluginRequest>> pluginRequestCountComparator = (reqs1, reqs2) -> {
        if (reqs1.size() != reqs2.size()) {
            return reqs2.size() - reqs1.size();
        }
        return ((PluginRequest)Iterables.get((Iterable)reqs1, (int)0)).getPluginName().toLowerCase().compareTo(((PluginRequest)Iterables.get((Iterable)reqs2, (int)0)).getPluginName().toLowerCase());
    };
    public static Comparator<PluginRequestRepresentation> requestComparator = Comparator.naturalOrder();
    private Function<PluginRequestRepresentation, Option<PluginRequest>> toPluginRequest = new Function<PluginRequestRepresentation, Option<PluginRequest>>(){

        public Option<PluginRequest> apply(PluginRequestRepresentation pluginRequestRepresentation) {
            UserKey userKey = new UserKey(pluginRequestRepresentation.getUser().getUserKey());
            if (PluginSettingsPluginRequestStore.this.userManager.getUserProfile(userKey) == null) {
                Runnable cleanupTask = () -> PluginSettingsPluginRequestStore.this.removeRequestsByUser(userKey);
                PluginSettingsPluginRequestStore.this.scheduler.triggerRunnable(cleanupTask, Duration.ZERO, "PluginSettingsPluginRequestStore cleanup task");
                return Option.none();
            }
            return Option.some(PluginSettingsPluginRequestStore.this.requestFactory.getPluginRequest(userKey, pluginRequestRepresentation.getPluginKey(), pluginRequestRepresentation.getPluginName(), new DateTime((Object)pluginRequestRepresentation.getTimestamp()), Option.option(pluginRequestRepresentation.getMessage())));
        }
    };
    private static Function<PluginRequest, String> requestToPluginKey = PluginRequest::getPluginKey;

    public PluginSettingsPluginRequestStore(PluginSettingsFactory pluginSettingsFactory, PluginRequestFactory requestFactory, UpmLinkBuilder linkBuilder, UpmUriBuilder uriBuilder, UserManager userManager, UpmScheduler scheduler, ClusterLockService lockService) {
        this(pluginSettingsFactory, requestFactory, linkBuilder, uriBuilder, userManager, scheduler, lockService, new ObjectMapper((JsonFactory)new MappingJsonFactory()));
    }

    public PluginSettingsPluginRequestStore(PluginSettingsFactory pluginSettingsFactory, PluginRequestFactory requestFactory, UpmLinkBuilder linkBuilder, UpmUriBuilder uriBuilder, UserManager userManager, UpmScheduler scheduler, ClusterLockService lockService, ObjectMapper mapper) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.requestFactory = (PluginRequestFactory)Preconditions.checkNotNull((Object)requestFactory, (Object)"requestFactory");
        this.linkBuilder = (UpmLinkBuilder)Preconditions.checkNotNull((Object)linkBuilder, (Object)"linkBuilder");
        this.uriBuilder = (UpmUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"mapper");
        this.scheduler = (UpmScheduler)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        this.lock = Locks.getLock((ClusterLockService)Preconditions.checkNotNull((Object)lockService, (Object)"lockService"), this.getClass());
    }

    private PluginSettings getPluginSettings() {
        return new NamespacedPluginSettings(this.pluginSettingsFactory.createGlobalSettings(), KEY_PREFIX);
    }

    @Override
    public Iterable<PluginRequest> getRequests() {
        return Locks.readWithLock(this.lock, this::getRequestsWithoutLocking);
    }

    private Iterable<PluginRequest> getRequestsWithoutLocking() {
        Iterable<PluginRequestRepresentation> reps = this.transformEntries(this.getSavedEntriesAsStrings());
        return Options.catOptions(Iterables.transform(reps, this.toPluginRequest));
    }

    @Override
    public Map<String, Iterable<PluginRequest>> getRequestsByPlugin(Integer maxResults, Integer startIndex) {
        return (Map)Locks.readWithLock(this.lock, () -> this.sortRequestsByAmountAndPlugin((Map<String, Collection<PluginRequest>>)Multimaps.index(this.getRequestsWithoutLocking(), requestToPluginKey).asMap(), maxResults, startIndex));
    }

    @Override
    public Map<String, Iterable<PluginRequest>> getRequestsByPluginExcludingUser(Integer maxResults, Integer startIndex, UserKey userKey) {
        return (Map)Locks.readWithLock(this.lock, () -> this.sortRequestsByAmountAndPlugin((Map<String, Collection<PluginRequest>>)Multimaps.index(this.getRequestsNotByUsersPlugins(userKey), requestToPluginKey).asMap(), maxResults, startIndex));
    }

    private ImmutableMap<String, Iterable<PluginRequest>> sortRequestsByAmountAndPlugin(Map<String, Collection<PluginRequest>> requestsByPlugin, Integer maxResults, Integer startIndex) {
        List requestedPluginKeys = Lists.transform((List)Ordering.from(pluginRequestCountComparator).sortedCopy(requestsByPlugin.values()), pluginRequests -> ((PluginRequest)Iterables.get((Iterable)pluginRequests, (int)0)).getPluginKey());
        int start = startIndex == null ? 0 : startIndex;
        int max = maxResults == null ? requestedPluginKeys.size() : Math.min(maxResults + start, requestedPluginKeys.size());
        ImmutableMap.Builder sortedPluginRequests = ImmutableMap.builder();
        for (String requestedPluginKey : requestedPluginKeys.subList(start, max)) {
            sortedPluginRequests.put((Object)requestedPluginKey, requestsByPlugin.get(requestedPluginKey));
        }
        return sortedPluginRequests.build();
    }

    private Iterable<PluginRequest> getRequestsNotByUsersPlugins(UserKey userKey) {
        Iterable<PluginRequestRepresentation> storedRequests = this.transformEntries(this.getSavedEntriesAsStrings());
        ImmutableMap userRequests = userKey != null ? this.getRequestsByUserInternal(userKey, storedRequests) : ImmutableMap.of();
        Iterable reps = Iterables.filter(storedRequests, (Predicate)Predicates.not(this.withAnyPluginKey(userRequests.keySet())));
        return Options.catOptions(Iterables.transform((Iterable)reps, this.toPluginRequest));
    }

    @Override
    public Map<String, PluginRequest> getRequestsByUser(UserKey userKey) {
        return Locks.readWithLock(this.lock, () -> {
            if (userKey == null) {
                return ImmutableMap.of();
            }
            Iterable<PluginRequestRepresentation> storedRequests = this.transformEntries(this.getSavedEntriesAsStrings());
            return this.getRequestsByUserInternal(userKey, storedRequests);
        });
    }

    private Map<String, PluginRequest> getRequestsByUserInternal(UserKey userKey, Iterable<PluginRequestRepresentation> storedRequests) {
        Iterable reps = Iterables.filter(storedRequests, this.byUser(userKey));
        ImmutableMap.Builder userPluginRequests = ImmutableMap.builder();
        for (PluginRequest request : Options.catOptions(Iterables.transform((Iterable)reps, this.toPluginRequest))) {
            userPluginRequests.put((Object)request.getPluginKey(), (Object)request);
        }
        return userPluginRequests.build();
    }

    @Override
    public Iterable<PluginRequest> getRequests(String pluginKey) {
        return (Iterable)Locks.readWithLock(this.lock, () -> {
            Iterable<PluginRequestRepresentation> storedRequests = this.transformEntries(this.getSavedEntriesAsStrings());
            Iterable reps = Iterables.filter(storedRequests, this.withPluginKey(pluginKey));
            return ImmutableList.copyOf(Options.catOptions(Iterables.transform((Iterable)reps, this.toPluginRequest)));
        });
    }

    @Override
    public Option<PluginRequest> getRequest(String pluginKey, UserKey userKey) {
        return Locks.readWithLock(this.lock, () -> {
            for (PluginRequestRepresentation rep : this.transformEntries(this.getSavedEntriesAsStrings())) {
                if (!rep.getPluginKey().equals(pluginKey) || !rep.getUser().getUserKey().equals(userKey.getStringValue())) continue;
                return (Option)this.toPluginRequest.apply((Object)rep);
            }
            return Option.none(PluginRequest.class);
        });
    }

    @Override
    public void addRequest(PluginRequest request) {
        Locks.writeWithLock(this.lock, () -> {
            try {
                Iterable requests = Iterables.filter(this.transformEntries(this.getSavedEntriesAsStrings()), (Predicate)Predicates.not(this.equalToRequest(request)));
                this.saveRequests((Iterable<PluginRequestRepresentation>)ImmutableList.builder().addAll(requests).add((Object)new PluginRequestRepresentation(request.getPluginKey(), request, this.linkBuilder, this.uriBuilder)).build());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save PluginRequest", e);
            }
        });
    }

    @Override
    public void removeRequests(String pluginKey) {
        Locks.writeWithLock(this.lock, () -> {
            try {
                Iterable<PluginRequestRepresentation> requests = this.transformEntries(this.getSavedEntriesAsStrings());
                this.saveRequests(Iterables.filter(requests, (Predicate)Predicates.not(this.withPluginKey(pluginKey))));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save PluginRequest", e);
            }
        });
    }

    @Override
    public void removeAllRequests() {
        Locks.writeWithLock(this.lock, () -> this.saveRequests((Iterable<PluginRequestRepresentation>)ImmutableList.of()));
    }

    private Iterable<String> getSavedEntriesAsStrings() {
        Object entries = this.getPluginSettings().get(REQUEST_KEY);
        if (entries == null) {
            return ImmutableList.of();
        }
        if (!(entries instanceof List)) {
            log.error("Invalid plugin request has been detected: " + entries);
            this.saveRequests((Iterable<PluginRequestRepresentation>)ImmutableList.of());
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)((List)entries));
    }

    private Iterable<PluginRequestRepresentation> transformEntries(Iterable<String> stringEntries) {
        Iterable reps = Iterables.transform(stringEntries, from -> {
            try {
                return (PluginRequestRepresentation)this.mapper.readValue(from, PluginRequestRepresentation.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse PluginRequestRepresentation from JSON string: " + from, e);
            }
        });
        return Ordering.from(requestComparator).sortedCopy(reps);
    }

    private void saveRequests(Iterable<PluginRequestRepresentation> stringEntries) {
        Iterable entries = Iterables.transform(stringEntries, from -> {
            try {
                return this.mapper.writeValueAsString(from);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save PluginRequestRepresentation to JSON: " + from, e);
            }
        });
        this.getPluginSettings().put(REQUEST_KEY, (Object)Lists.newArrayList((Iterable)entries));
    }

    private void removeRequestsByUser(UserKey userKey) {
        Locks.writeWithLock(this.lock, () -> {
            try {
                Iterable<PluginRequestRepresentation> requests = this.transformEntries(this.getSavedEntriesAsStrings());
                this.saveRequests(Iterables.filter(requests, (Predicate)Predicates.not(this.byUser(userKey))));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save PluginRequest", e);
            }
        });
    }

    private Predicate<PluginRequestRepresentation> equalToRequest(PluginRequest pluginRequest) {
        return new EqualToRequest(pluginRequest);
    }

    private Predicate<PluginRequestRepresentation> withPluginKey(String pluginKey) {
        return new WithPluginKey(pluginKey);
    }

    private Predicate<PluginRequestRepresentation> withAnyPluginKey(Set<String> pluginKeys) {
        return new WithAnyPluginKey(pluginKeys);
    }

    private Predicate<PluginRequestRepresentation> byUser(UserKey userKey) {
        return new ByUser(userKey);
    }

    private static class ByUser
    implements Predicate<PluginRequestRepresentation> {
        private UserKey userKey;

        ByUser(UserKey userKey) {
            this.userKey = userKey;
        }

        public boolean apply(PluginRequestRepresentation rep) {
            return rep.getUser().getUserKey().equals(this.userKey.getStringValue());
        }
    }

    private static class WithAnyPluginKey
    implements Predicate<PluginRequestRepresentation> {
        private Set<String> pluginKeys;

        WithAnyPluginKey(Set<String> pluginKeys) {
            this.pluginKeys = pluginKeys;
        }

        public boolean apply(PluginRequestRepresentation rep) {
            return this.pluginKeys.contains(rep.getPluginKey());
        }
    }

    private static class WithPluginKey
    implements Predicate<PluginRequestRepresentation> {
        private String pluginKey;

        WithPluginKey(String pluginKey) {
            this.pluginKey = pluginKey;
        }

        public boolean apply(PluginRequestRepresentation rep) {
            return rep.getPluginKey().equals(this.pluginKey);
        }
    }

    private static class EqualToRequest
    implements Predicate<PluginRequestRepresentation> {
        private PluginRequest request;

        EqualToRequest(PluginRequest request) {
            this.request = request;
        }

        public boolean apply(PluginRequestRepresentation rep) {
            return rep.getPluginKey().equals(this.request.getPluginKey()) && rep.getUser().getUserKey().equals(this.request.getUser().getUserKey().getStringValue());
        }
    }
}

