/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.rest.representations;

import com.atlassian.upm.osgi.Package;
import com.atlassian.upm.osgi.impl.Wrapper;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class PackageSummaryRepresentation {
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String version;
    @JsonProperty
    Map<String, URI> links;

    @JsonCreator
    public PackageSummaryRepresentation(@JsonProperty(value="name") String name, @JsonProperty(value="version") String version, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.links = ImmutableMap.copyOf(links);
    }

    public PackageSummaryRepresentation(Package pkg, UpmUriBuilder uriBuilder) {
        this.name = pkg.getName();
        this.version = pkg.getVersion().toString();
        this.links = ImmutableMap.of((Object)"self", (Object)uriBuilder.buildOsgiPackageUri(pkg));
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public static Wrapper<Package, PackageSummaryRepresentation> wrapSummary(final UpmUriBuilder uriBuilder) {
        return new Wrapper<Package, PackageSummaryRepresentation>("packageSummaryRepresentation"){

            @Override
            public PackageSummaryRepresentation wrap(Package pkg) {
                return new PackageSummaryRepresentation(pkg, uriBuilder);
            }
        };
    }
}

