/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.notification.DismissedState;
import com.atlassian.upm.notification.Notification;
import com.atlassian.upm.notification.NotificationCollection;
import com.atlassian.upm.notification.NotificationFactory;
import com.atlassian.upm.notification.NotificationType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public class NotificationFactoryImpl
implements NotificationFactory {
    private final UserManager userManager;

    public NotificationFactoryImpl(UserManager userManager) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
    }

    @Override
    public Notification getNotification(NotificationType type, String pluginKey, boolean dismissed) {
        return new Notification(type, pluginKey, this.getDismissedState(dismissed));
    }

    @Override
    public NotificationCollection getNotifications(NotificationType type, Iterable<Pair<String, Boolean>> plugins, boolean typeDismissed) {
        ImmutableList.Builder notifications = ImmutableList.builder();
        for (Pair<String, Boolean> plugin : plugins) {
            notifications.add((Object)this.getNotification(type, plugin.first(), plugin.second()));
        }
        return new NotificationCollection(type, this.getDismissedState(typeDismissed), (Iterable<Notification>)notifications.build());
    }

    @Override
    public NotificationCollection getNotifications(NotificationType type, int count, boolean typeDismissed) {
        return new NotificationCollection(type, this.getDismissedState(typeDismissed), count);
    }

    private DismissedState getDismissedState(boolean dismissed) {
        return new DismissedState(this.userManager.getRemoteUserKey(), dismissed);
    }
}

