/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.Pairs;
import com.atlassian.upm.UserSettings;
import com.atlassian.upm.UserSettingsStore;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.impl.NamespacedPluginSettings;
import com.atlassian.upm.mail.EmailType;
import com.atlassian.upm.mail.ProductUserLists;
import com.atlassian.upm.mail.UpmMailSenderService;
import com.atlassian.upm.notification.ManualUpdateRequiredNotificationService;
import com.atlassian.upm.pac.AvailableAddonWithVersion;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualUpdateRequiredNotificationServiceImpl
implements ManualUpdateRequiredNotificationService {
    private static final int MAX_EMAILS = 3;
    private static final String KEY_PREFIX = ManualUpdateRequiredNotificationServiceImpl.class.getName();
    private static final String MANUAL_UPDATE_NOTIFICATIONS = "manual-update-notifications";
    private static final Logger log = LoggerFactory.getLogger(ManualUpdateRequiredNotificationServiceImpl.class);
    private final PluginRetriever pluginRetriever;
    private final UpmMailSenderService mailSenderService;
    private final UserSettingsStore userSettingsStore;
    private final ProductUserLists userLists;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ObjectMapper mapper;
    private Predicate<UserKey> disabledEmail = new Predicate<UserKey>(){

        public boolean apply(UserKey userKey) {
            return ManualUpdateRequiredNotificationServiceImpl.this.userSettingsStore.getBoolean(userKey, UserSettings.DISABLE_EMAIL);
        }
    };
    private Function<String, Option<ManualUpdateEmailRepresentation>> toEmailRepresentation = new Function<String, Option<ManualUpdateEmailRepresentation>>(){

        public Option<ManualUpdateEmailRepresentation> apply(String from) {
            try {
                return Option.some(ManualUpdateRequiredNotificationServiceImpl.this.mapper.readValue(from, ManualUpdateEmailRepresentation.class));
            }
            catch (IOException e) {
                log.warn("Failed to parse ManualUpdateEmailRepresentation from JSON string: " + from, (Throwable)e);
                return Option.none();
            }
        }
    };
    private Function<ManualUpdateEmailRepresentation, Option<String>> fromEmailRepresentation = new Function<ManualUpdateEmailRepresentation, Option<String>>(){

        public Option<String> apply(ManualUpdateEmailRepresentation from) {
            try {
                return Option.some(ManualUpdateRequiredNotificationServiceImpl.this.mapper.writeValueAsString((Object)from));
            }
            catch (IOException e) {
                log.warn("Failed to save ManualUpdateEmailRepresentation from JSON string: " + from, (Throwable)e);
                return Option.none();
            }
        }
    };

    public ManualUpdateRequiredNotificationServiceImpl(PluginRetriever pluginRetriever, UpmMailSenderService mailSenderService, UserSettingsStore userSettingsStore, ProductUserLists userLists, PluginSettingsFactory pluginSettingsFactory) {
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.mailSenderService = (UpmMailSenderService)Preconditions.checkNotNull((Object)mailSenderService, (Object)"mailSenderService");
        this.userSettingsStore = (UserSettingsStore)Preconditions.checkNotNull((Object)userSettingsStore, (Object)"userSettingsStore");
        this.userLists = (ProductUserLists)Preconditions.checkNotNull((Object)userLists, (Object)"userLists");
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.mapper = new ObjectMapper((JsonFactory)new MappingJsonFactory());
    }

    @Override
    public void sendFreeToPaidNotification(AvailableAddonWithVersion update) {
        this.sendManualUpdateEmail(update, EmailType.ADDON_UPDATE_FREE_TO_PAID, this.getPermittedUsers(EmailType.ADDON_UPDATE_FREE_TO_PAID), (Map<String, Object>)ImmutableMap.of());
    }

    @Override
    public void clearEmailRecords(String pluginKey) {
        this.saveEntries(Iterables.filter(this.getManualUpdateEmails(), (Predicate)Predicates.not(this.withPluginKey(pluginKey))));
    }

    private Set<UserKey> getPermittedUsers(EmailType emailType) {
        switch (emailType) {
            case ADDON_UPDATE_FREE_TO_PAID: {
                return this.userLists.getSystemAdmins();
            }
        }
        return ImmutableSet.of();
    }

    private void sendManualUpdateEmail(AvailableAddonWithVersion update, EmailType emailType, Set<UserKey> userKeys, Map<String, Object> context) {
        if (!this.mailSenderService.canSendEmail()) {
            return;
        }
        for (Plugin installedPlugin : this.pluginRetriever.getPlugin(update.getAddon().getKey())) {
            if (!this.shouldSendEmail(installedPlugin, emailType)) {
                return;
            }
            Iterable recipients = Iterables.filter(userKeys, (Predicate)Predicates.not(this.disabledEmail));
            for (UserKey userKey : recipients) {
                this.mailSenderService.sendUpmEmail(emailType, Pairs.ImmutablePair.pair(update.getAddon().getKey(), update.getAddon().getName()), (Set<UserKey>)ImmutableSet.of((Object)userKey), (Iterable<String>)ImmutableList.of((Object)update.getAddon().getName()), context);
            }
            if (Iterables.isEmpty((Iterable)recipients)) continue;
            this.recordEmail(installedPlugin, emailType);
        }
    }

    private boolean shouldSendEmail(Plugin plugin, EmailType emailType) {
        if (!plugin.isEnabled()) {
            return false;
        }
        Iterable<ManualUpdateEmailRepresentation> emails = this.getEmailsFor(plugin, emailType);
        int size = Iterables.size(emails);
        if (size >= 3) {
            return false;
        }
        if (size == 2) {
            return Iterables.all(emails, this.olderThan(Duration.standardDays((long)3L)));
        }
        if (size == 1) {
            return Iterables.all(emails, this.olderThan(Duration.standardDays((long)1L)));
        }
        return true;
    }

    private void recordEmail(Plugin plugin, EmailType emailType) {
        ImmutableList newList = ImmutableList.builder().addAll(this.getManualUpdateEmails()).add((Object)new ManualUpdateEmailRepresentation(plugin.getKey(), plugin.getVersion(), emailType.toString(), new Date())).build();
        this.saveEntries((Iterable<ManualUpdateEmailRepresentation>)newList);
    }

    private Iterable<ManualUpdateEmailRepresentation> getEmailsFor(Plugin plugin, EmailType emailType) {
        return Iterables.filter(this.getManualUpdateEmails(), this.withPluginAndEmailType(plugin, emailType));
    }

    private Iterable<ManualUpdateEmailRepresentation> getManualUpdateEmails() {
        Object entries = this.getPluginSettings().get(MANUAL_UPDATE_NOTIFICATIONS);
        if (entries == null) {
            return new ArrayList<ManualUpdateEmailRepresentation>();
        }
        if (!(entries instanceof List)) {
            log.error("Invalid emails storage has been detected: " + entries);
            this.saveEntries((Iterable<ManualUpdateEmailRepresentation>)ImmutableList.of());
            return new ArrayList<ManualUpdateEmailRepresentation>();
        }
        return Options.catOptions(Iterables.transform((Iterable)((List)entries), this.toEmailRepresentation));
    }

    private void saveEntries(Iterable<ManualUpdateEmailRepresentation> manualUpdateEmails) {
        this.getPluginSettings().put(MANUAL_UPDATE_NOTIFICATIONS, (Object)Lists.newArrayList(Options.catOptions(Iterables.transform(manualUpdateEmails, this.fromEmailRepresentation))));
    }

    private PluginSettings getPluginSettings() {
        return new NamespacedPluginSettings(this.pluginSettingsFactory.createGlobalSettings(), KEY_PREFIX);
    }

    private Predicate<ManualUpdateEmailRepresentation> withPluginAndEmailType(final Plugin plugin, final EmailType emailType) {
        return new Predicate<ManualUpdateEmailRepresentation>(){

            public boolean apply(ManualUpdateEmailRepresentation email) {
                return email.getEmailType().equals(emailType.toString()) && email.getPluginKey().equals(plugin.getKey()) && email.getVersion().equals(plugin.getVersion());
            }
        };
    }

    private Predicate<ManualUpdateEmailRepresentation> withPluginKey(final String pluginKey) {
        return new Predicate<ManualUpdateEmailRepresentation>(){

            public boolean apply(ManualUpdateEmailRepresentation email) {
                return email.getPluginKey().equals(pluginKey);
            }
        };
    }

    private Predicate<? super ManualUpdateEmailRepresentation> olderThan(final Duration duration) {
        return new Predicate<ManualUpdateEmailRepresentation>(){

            public boolean apply(ManualUpdateEmailRepresentation email) {
                return new DateTime((Object)email.getDateSent()).isBefore((ReadableInstant)new DateTime().minus((ReadableDuration)duration));
            }
        };
    }

    public static final class ManualUpdateEmailRepresentation {
        @JsonProperty
        private final String pluginKey;
        @JsonProperty
        private final String version;
        @JsonProperty
        private final String emailType;
        @JsonProperty
        private final Date dateSent;

        @JsonCreator
        public ManualUpdateEmailRepresentation(@JsonProperty(value="pluginKey") String pluginKey, @JsonProperty(value="version") String version, @JsonProperty(value="emailType") String emailType, @JsonProperty(value="dateSent") Date dateSent) {
            this.pluginKey = pluginKey;
            this.version = version;
            this.emailType = emailType;
            this.dateSent = dateSent;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getVersion() {
            return this.version;
        }

        public String getEmailType() {
            return this.emailType;
        }

        public Date getDateSent() {
            return this.dateSent;
        }
    }
}

