/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.mail.ProductUserLists;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JiraUserLists
implements ProductUserLists {
    private final UserUtil userUtil;
    private Function<Principal, UserKey> toUserKeys;

    public JiraUserLists(UserUtil userUtil, UserManager userManager) {
        this.userUtil = (UserUtil)Preconditions.checkNotNull((Object)userUtil, (Object)"userUtil");
        this.toUserKeys = user -> userManager.getUserProfile(user.getName()).getUserKey();
    }

    @Override
    public Set<UserKey> getSystemAdmins() {
        return ImmutableSet.copyOf((Collection)this.userUtil.getJiraSystemAdministrators().stream().map(this.toUserKeys).collect(Collectors.toList()));
    }

    @Override
    public Set<UserKey> getAdminsAndSystemAdmins() {
        return ImmutableSet.copyOf((Collection)this.userUtil.getJiraAdministrators().stream().map(this.toUserKeys).collect(Collectors.toList()));
    }
}

