/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.mail.ProductUserLists;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ConfluenceUserLists
implements ProductUserLists {
    private final UserAccessor userAccessor;
    private final UserManager userManager;

    public ConfluenceUserLists(UserAccessor userAccessor, UserManager userManager) {
        this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor, (Object)"userAccessor");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
    }

    @Override
    public Set<UserKey> getSystemAdmins() {
        Predicate<UserKey> isSystemAdmin = arg_0 -> ((UserManager)this.userManager).isSystemAdmin(arg_0);
        return ImmutableSet.copyOf((Collection)StreamSupport.stream(this.getConfluenceAdministrators().spliterator(), false).filter(isSystemAdmin).collect(Collectors.toList()));
    }

    @Override
    public Set<UserKey> getAdminsAndSystemAdmins() {
        return ImmutableSet.copyOf(this.getConfluenceAdministrators());
    }

    private Iterable<UserKey> getConfluenceAdministrators() {
        Group adminGroup = this.userAccessor.getGroup("confluence-administrators");
        if (adminGroup == null) {
            return ImmutableList.of();
        }
        Pager usernamesPager = this.userAccessor.getMemberNames(adminGroup);
        if (usernamesPager == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterator)usernamesPager.iterator()).stream().map(UserKey::new).collect(Collectors.toList());
    }
}

