/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.mail.ProductUserLists;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BambooUserLists
implements ProductUserLists {
    private final BambooPermissionManager bambooPermissionManager;
    private final BambooUserManager bambooUserManager;

    public BambooUserLists(BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager) {
        this.bambooPermissionManager = (BambooPermissionManager)Preconditions.checkNotNull((Object)bambooPermissionManager, (Object)"bambooPermissionManager");
        this.bambooUserManager = (BambooUserManager)Preconditions.checkNotNull((Object)bambooUserManager, (Object)"bambooUserManager");
    }

    @Override
    public Set<UserKey> getSystemAdmins() {
        return this.getAdminsAndSystemAdmins();
    }

    @Override
    public Set<UserKey> getAdminsAndSystemAdmins() {
        Function<String, Iterable> toAdminList = adminGroup -> this.bambooUserManager.getMemberNamesAsList(this.bambooUserManager.getGroup(adminGroup)).stream().map(UserKey::new).collect(Collectors.toList());
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)this.bambooPermissionManager.getAdminGroups().stream().map(toAdminList).collect(Collectors.toList())));
    }
}

