/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.impl;

import com.atlassian.plugin.PluginState;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.PluginsEnablementStateStore;
import com.atlassian.upm.SafeModeService;
import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.core.ApplicationPluginsManager;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginEnablementService;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginModuleNotFoundException;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.PluginsEnablementState;
import com.atlassian.upm.core.impl.SafeModeAccessorImpl;
import com.atlassian.upm.core.log.AuditLogService;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SafeModeServiceImpl
extends SafeModeAccessorImpl
implements SafeModeService {
    private static final Logger log = LoggerFactory.getLogger(SafeModeServiceImpl.class);
    private final PluginEnablementService enabler;
    private final AuditLogService auditLogger;
    private final PluginsEnablementStateStore enablementStateStore;
    private final TransactionTemplate txTemplate;
    private final PluginRetriever pluginRetriever;
    private final ApplicationPluginsManager applicationPluginsManager;

    public SafeModeServiceImpl(UpmPluginAccessor pluginAccessor, PluginEnablementService enabler, AuditLogService auditLogger, PluginsEnablementStateStore enablementStateStore, TransactionTemplate txTemplate, PluginMetadataAccessor metadata, PluginRetriever pluginRetriever, ApplicationPluginsManager applicationPluginsManager) {
        super(pluginAccessor, pluginRetriever, metadata, enablementStateStore);
        this.enabler = (PluginEnablementService)Preconditions.checkNotNull((Object)enabler, (Object)"enabler");
        this.auditLogger = (AuditLogService)Preconditions.checkNotNull((Object)auditLogger, (Object)"auditLogger");
        this.enablementStateStore = (PluginsEnablementStateStore)Preconditions.checkNotNull((Object)enablementStateStore, (Object)"enablementStateStore");
        this.txTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)txTemplate, (Object)"txTemplate");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.applicationPluginsManager = (ApplicationPluginsManager)Preconditions.checkNotNull((Object)applicationPluginsManager, (Object)"applicationPluginsManager");
    }

    @Override
    public boolean enterSafeMode() {
        this.auditLogger.logI18nMessage("upm.auditLog.safeMode.enter.start", new String[0]);
        final Iterable<Plugin> plugins = this.pluginRetriever.getPlugins();
        final PluginsEnablementState config = this.getCurrentConfiguration(plugins);
        this.txTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                try {
                    SafeModeServiceImpl.this.enablementStateStore.saveConfiguration(config);
                }
                catch (RuntimeException e) {
                    SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.enter.failure", new String[0]);
                    throw e;
                }
                return null;
            }
        });
        return (Boolean)this.txTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                try {
                    boolean successful;
                    boolean bl = successful = SafeModeServiceImpl.this.isSafeMode() && SafeModeServiceImpl.this.disableAllUserInstalledPlugins(plugins, config);
                    if (successful) {
                        SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.enter.success", new String[0]);
                    } else {
                        SafeModeServiceImpl.this.enablementStateStore.removeSavedConfiguration();
                        SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.enter.failure", new String[0]);
                    }
                    return successful;
                }
                catch (RuntimeException e) {
                    SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.enter.failure", new String[0]);
                    throw e;
                }
            }
        });
    }

    @Override
    public void exitSafeMode(final boolean keepState) {
        this.auditLogger.logI18nMessage("upm.auditLog.safeMode.exit.start", new String[0]);
        this.txTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                try {
                    if (!keepState) {
                        Option<PluginsEnablementState> config = SafeModeServiceImpl.this.enablementStateStore.getSavedConfiguration();
                        if (config.isDefined()) {
                            for (PluginsEnablementState savedConfiguration : config) {
                                SafeModeServiceImpl.this.applyConfiguration(savedConfiguration);
                            }
                        } else {
                            throw new SafeModeService.MissingSavedConfigurationException();
                        }
                    }
                    SafeModeServiceImpl.this.enablementStateStore.removeSavedConfiguration();
                    SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.exit.success", new String[0]);
                }
                catch (SafeModeService.MissingSavedConfigurationException msce) {
                    SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.exit.failure.missing.configuration", new String[0]);
                    throw msce;
                }
                catch (SafeModeService.PluginStateUpdateException psue) {
                    SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.exit.failure.restoring.plugin.state", psue.getPlugin().getName(), psue.getPlugin().getKey());
                    throw psue;
                }
                catch (SafeModeService.PluginModuleStateUpdateException pmsue) {
                    SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.exit.failure.restoring.plugin.module.state", pmsue.getModule().getName(), pmsue.getModule().getPlugin().getName(), pmsue.getModule().getCompleteKey());
                    throw pmsue;
                }
                catch (RuntimeException re) {
                    SafeModeServiceImpl.this.auditLogger.logI18nMessage("upm.auditLog.safeMode.exit.failure", new String[0]);
                    throw re;
                }
                return null;
            }
        });
    }

    private boolean disableAllUserInstalledPlugins(Iterable<Plugin> allPlugins, PluginsEnablementState previousPluginsState) {
        Iterable pluginsToDisable;
        ImmutableList<Plugin> disableOrder;
        final Set<String> applicationPluginKeys = this.applicationPluginsManager.getApplicationRelatedPluginKeys();
        if (!Iterables.isEmpty(applicationPluginKeys)) {
            log.info("Excluding the following plugins from Safe Mode because they are parts of applications: " + applicationPluginKeys);
        }
        if (!this.disablePlugins((Iterable<Plugin>)(disableOrder = this.sortByDependencies(false, pluginsToDisable = Iterables.filter(allPlugins, (Predicate)new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return !plugin.isUpmPlugin() && SafeModeServiceImpl.this.metadata.isUserInstalled(plugin) && PluginState.ENABLED.equals((Object)plugin.getPluginState()) && !applicationPluginKeys.contains(plugin.getKey());
            }
        }))))) {
            this.applyConfigurations(previousPluginsState.getPlugins(), allPlugins, false);
            return false;
        }
        return true;
    }

    private boolean disablePlugins(Iterable<Plugin> plugins) {
        for (Plugin p : plugins) {
            if (!p.isEnabled() || this.enabler.disablePlugin(p.getKey())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void applyConfiguration(PluginsEnablementState configuration) {
        Iterable<Plugin> allPlugins = this.pluginRetriever.getPlugins();
        Iterable<PluginsEnablementState.PluginState> previousPluginsState = this.getCurrentPluginsConfigurationState(allPlugins);
        try {
            this.applyConfigurations(configuration.getPlugins(), allPlugins, true);
        }
        catch (RuntimeException e) {
            this.applyConfigurations(previousPluginsState, allPlugins, false);
            throw e;
        }
    }

    private void applyConfigurations(Iterable<PluginsEnablementState.PluginState> configs, Iterable<Plugin> allPlugins, boolean terminateOnFailure) {
        this.applyConfigurationsInternal(configs, allPlugins, true, terminateOnFailure);
        this.applyConfigurationsInternal(configs, allPlugins, false, terminateOnFailure);
    }

    private void applyConfigurationsInternal(Iterable<PluginsEnablementState.PluginState> allConfigs, Iterable<Plugin> allPlugins, boolean enable, boolean terminateOnFailure) {
        Iterable configs = Iterables.filter(allConfigs, PluginsEnablementState.pluginStateEnabled(enable));
        ImmutableMap configsByKey = Maps.uniqueIndex((Iterable)configs, PluginsEnablementState.pluginStateKey());
        Iterable plugins = Iterables.filter(allPlugins, (Predicate)Predicates.compose((Predicate)Predicates.in(configsByKey.keySet()), Plugins.toPluginKey));
        Iterable pluginsRequiringChange = Iterables.filter((Iterable)plugins, Plugins.enabled(!enable, this.pluginRetriever));
        ImmutableList<Plugin> sortedPlugins = this.sortByDependencies(enable, pluginsRequiringChange);
        for (Plugin p : sortedPlugins) {
            PluginsEnablementState.PluginState pluginConfiguration = (PluginsEnablementState.PluginState)Option.option(configsByKey.get(p.getKey())).getOrElse(new PluginsEnablementState.PluginState.Builder(p.getKey(), true, (Iterable<PluginsEnablementState.ModuleState>)ImmutableList.of()).build());
            if (!this.setPluginState(pluginConfiguration)) {
                if (!terminateOnFailure) continue;
                throw new SafeModeService.PluginStateUpdateException(p, pluginConfiguration.isEnabled());
            }
            for (Plugin.Module m : p.getModules()) {
                boolean shouldBeEnabled;
                if (this.setPluginModuleState(m, shouldBeEnabled = pluginConfiguration.isModuleEnabled(m.getCompleteKey())) || !terminateOnFailure) continue;
                throw new SafeModeService.PluginModuleStateUpdateException(m, shouldBeEnabled);
            }
        }
    }

    private Iterable<PluginsEnablementState.PluginState> getCurrentPluginsConfigurationState(Iterable<Plugin> plugins) {
        return this.transformPluginToPluginConfigurations(plugins);
    }

    private boolean setPluginState(PluginsEnablementState.PluginState pluginConfiguration) {
        String pluginKey = pluginConfiguration.getKey();
        if (pluginConfiguration.isEnabled() != this.pluginRetriever.isPluginEnabled(pluginKey)) {
            if (pluginConfiguration.isEnabled()) {
                return this.enabler.enablePlugin(pluginKey);
            }
            return this.enabler.disablePlugin(pluginKey);
        }
        return true;
    }

    private boolean setPluginModuleState(Plugin.Module pluginModule, boolean shouldBeEnabled) {
        if (shouldBeEnabled != this.pluginRetriever.isPluginModuleEnabled(pluginModule.getCompleteKey())) {
            if (shouldBeEnabled) {
                try {
                    return this.enabler.enablePluginModule(pluginModule.getCompleteKey());
                }
                catch (PluginModuleNotFoundException e) {
                    return true;
                }
            }
            return this.enabler.disablePluginModule(pluginModule.getCompleteKey());
        }
        return true;
    }

    private ImmutableList<Plugin> sortByDependencies(boolean dependenciesFirst, Iterable<Plugin> plugins) {
        ImmutableSet allPluginKeys = ImmutableSet.copyOf((Iterable)Iterables.transform(plugins, Plugins.toPluginKey));
        ImmutableList<Plugin> sortedWithDependenciesFirst = this.getWithDependenciesFirst(plugins, (ImmutableSet<String>)allPluginKeys, new HashSet<String>());
        if (dependenciesFirst) {
            return sortedWithDependenciesFirst;
        }
        ArrayList list = Lists.newArrayList(sortedWithDependenciesFirst);
        Collections.reverse(list);
        return ImmutableList.copyOf((Collection)list);
    }

    private ImmutableList<Plugin> getWithDependenciesFirst(Iterable<Plugin> plugins, ImmutableSet<String> allPluginKeys, Set<String> pluginKeysAlreadyVisited) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (Plugin p : plugins) {
            String key = p.getKey();
            if (!allPluginKeys.contains((Object)key) || pluginKeysAlreadyVisited.contains(key)) continue;
            pluginKeysAlreadyVisited.add(key);
            Iterable<Plugin> deps = Options.catOptions(Iterables.transform((Iterable)p.getPlugin().getDependencies().getAll(), Plugins.toInstalledPlugin(this.pluginRetriever)));
            if (!Iterables.isEmpty(deps)) {
                list.addAll(this.getWithDependenciesFirst(deps, allPluginKeys, pluginKeysAlreadyVisited));
            }
            list.add((Object)p);
        }
        return list.build();
    }
}

