/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.impl;

import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.PluginUpdateRequestStore;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.impl.NamespacedPluginSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSettingsPluginUpdateRequestStore
implements PluginUpdateRequestStore {
    static final String KEY_PREFIX = PluginSettingsPluginUpdateRequestStore.class.getName();
    static final String PLUGIN_UPDATE_REQUESTS = "plugin-update-requests";
    private static final Logger log = LoggerFactory.getLogger(PluginSettingsPluginUpdateRequestStore.class);
    private final PluginSettingsFactory pluginSettingsFactory;

    public PluginSettingsPluginUpdateRequestStore(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
    }

    private Iterable<String> getPluginUpdateRequests() {
        Object entries = this.getPluginSettings().get(PLUGIN_UPDATE_REQUESTS);
        if (entries == null) {
            return new ArrayList<String>();
        }
        if (!(entries instanceof List)) {
            log.error("Invalid plugin update request storage has been detected: " + entries);
            this.saveEntries((Iterable<String>)ImmutableList.of());
            return new ArrayList<String>();
        }
        return ImmutableList.copyOf((Collection)((List)entries));
    }

    @Override
    public void requestPluginUpdate(Plugin installedPlugin) {
        this.requestPluginUpdate(installedPlugin.getKey());
    }

    @Override
    public void requestPluginUpdate(Addon availablePlugin) {
        this.requestPluginUpdate(availablePlugin.getKey());
    }

    private void requestPluginUpdate(String pluginKey) {
        Iterable<String> pluginUpdateRequests = this.getPluginUpdateRequests();
        ImmutableList newList = ImmutableList.builder().addAll(pluginUpdateRequests).add((Object)pluginKey).build();
        this.saveEntries((Iterable<String>)newList);
    }

    @Override
    public void resetPluginUpdateRequest(Plugin plugin) {
        this.saveEntries(Iterables.filter(this.getPluginUpdateRequests(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)plugin.getKey()))));
    }

    @Override
    public boolean isPluginUpdateRequested(Plugin plugin) {
        return Iterables.any(this.getPluginUpdateRequests(), (Predicate)Predicates.equalTo((Object)plugin.getKey()));
    }

    private void saveEntries(Iterable<String> pluginUpdateRequests) {
        this.getPluginSettings().put(PLUGIN_UPDATE_REQUESTS, (Object)Lists.newArrayList(pluginUpdateRequests));
    }

    private PluginSettings getPluginSettings() {
        return new NamespacedPluginSettings(this.pluginSettingsFactory.createGlobalSettings(), KEY_PREFIX);
    }
}

