/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.analytics.impl;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.analytics.AnalyticsEvent;
import com.atlassian.upm.core.analytics.AnalyticsLogger;
import com.atlassian.upm.core.analytics.AnalyticsPublisher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class AtlassianAnalyticsPublisher
implements AnalyticsPublisher {
    private final AnalyticsLogger analytics;
    private final EventPublisher eventPublisher;

    public AtlassianAnalyticsPublisher(AnalyticsLogger analytics, EventPublisher eventPublisher) {
        this.analytics = (AnalyticsLogger)Preconditions.checkNotNull((Object)analytics, (Object)"analytics");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
    }

    @Override
    public void publish(AnalyticsEvent event) throws Exception {
        if (!event.isRecordedByMarketplace()) {
            ImmutableMap.Builder props = ImmutableMap.builder();
            for (Pair<String, String> p : event.getMetadata()) {
                props.put((Object)p.first(), (Object)p.second());
            }
            EventWrapper ew = new EventWrapper(event.getEventType(), (Map<String, String>)props.build());
            this.eventPublisher.publish((Object)ew);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.analytics.register(this);
    }

    public void destroy() throws Exception {
        this.analytics.unregister(this);
    }

    @EventName(value="browser")
    public static class EventWrapper {
        private final String name;
        private final ImmutableMap<String, String> properties;

        EventWrapper(String name, Map<String, String> properties) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.properties = ImmutableMap.copyOf(properties);
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

