/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core;

import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginFactory;
import com.atlassian.upm.spi.PluginInstallResult;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class PluginWithDependenciesInstallResult {
    private final Plugin plugin;
    private final Iterable<Plugin> dependencies;

    private PluginWithDependenciesInstallResult(PluginInstallResult result, PluginFactory pluginFactory) {
        this.plugin = pluginFactory.createPlugin(result.getPlugin());
        this.dependencies = ImmutableList.copyOf((Collection)StreamSupport.stream(result.getDependencies().spliterator(), false).map(pluginFactory::createPlugin).collect(Collectors.toList()));
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Iterable<Plugin> getDependencies() {
        return this.dependencies;
    }

    public static PluginWithDependenciesInstallResult from(PluginInstallResult result, PluginFactory pluginFactory) {
        return new PluginWithDependenciesInstallResult(result, pluginFactory);
    }
}

