/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.analytics.rest.resources;

import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.analytics.event.UpmUiAnalyticsEvent;
import com.atlassian.upm.core.analytics.AnalyticsLogger;
import com.atlassian.upm.core.analytics.event.DefaultAnalyticsEvent;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="/analytics")
@WebSudoNotRequired
public class AnalyticsResource {
    private static final ImmutableSet<String> MARKETPLACE_EVENT_TYPES = ImmutableSet.of((Object)"page-source", (Object)"notification-badge-click", (Object)"connect-install-warning-accept", (Object)"connect-install-warning-cancel", (Object)"postinstall", (Object)"postupdate", (Object[])new String[]{"buy", "try", "upgrade", "renew", "retrieve-license"});
    private final AnalyticsLogger analytics;
    private final PermissionEnforcer permissionEnforcer;

    public AnalyticsResource(AnalyticsLogger analytics, PermissionEnforcer permissionEnforcer) {
        this.analytics = (AnalyticsLogger)Preconditions.checkNotNull((Object)analytics, (Object)"analytics");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response addEvent(AnalyticsDataRepresentation data) {
        this.permissionEnforcer.enforcePermission(Permission.ADD_ANALYTICS_ACTIVITY);
        DefaultAnalyticsEvent event = MARKETPLACE_EVENT_TYPES.contains((Object)data.getType()) ? new UpmUiAnalyticsEvent(data.getType(), data.getData()) : new DefaultAnalyticsEvent(data.getType(), data.getData());
        this.analytics.log(event);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    public static final class AnalyticsDataRepresentation {
        @JsonProperty
        private Map<String, String> data;
        private String type;

        @JsonCreator
        public AnalyticsDataRepresentation(@JsonProperty(value="data") Map<String, String> data) {
            this.type = data.get("type");
            this.data = ImmutableMap.copyOf((Map)Maps.filterKeys(data, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"type"))));
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getData() {
            return this.data;
        }
    }
}

