/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.upm.core.Plugin;
import com.google.common.collect.ImmutableList;

public final class ProductUpdatePluginCompatibility {
    private final Iterable<Plugin> compatible;
    private final Iterable<Plugin> updateRequired;
    private final Iterable<Plugin> updateRequiredAfterProductUpdate;
    private final Iterable<Plugin> incompatible;
    private final Iterable<Plugin> unknown;

    private ProductUpdatePluginCompatibility(Builder builder) {
        this.compatible = builder.compatible.build();
        this.updateRequired = builder.updateRequired.build();
        this.updateRequiredAfterProductUpdate = builder.updateRequiredAfterProductUpdate.build();
        this.incompatible = builder.incompatible.build();
        this.unknown = builder.unknown.build();
    }

    public Iterable<Plugin> getCompatible() {
        return this.compatible;
    }

    public Iterable<Plugin> getUpdateRequired() {
        return this.updateRequired;
    }

    public Iterable<Plugin> getUpdateRequiredAfterProductUpdate() {
        return this.updateRequiredAfterProductUpdate;
    }

    public Iterable<Plugin> getIncompatible() {
        return this.incompatible;
    }

    public Iterable<Plugin> getUnknown() {
        return this.unknown;
    }

    public static class Builder {
        private ImmutableList.Builder<Plugin> compatible = new ImmutableList.Builder();
        private ImmutableList.Builder<Plugin> updateRequired = new ImmutableList.Builder();
        private ImmutableList.Builder<Plugin> updateRequiredAfterProductUpdate = new ImmutableList.Builder();
        private ImmutableList.Builder<Plugin> incompatible = new ImmutableList.Builder();
        private ImmutableList.Builder<Plugin> unknown = new ImmutableList.Builder();

        public Builder addCompatible(Plugin compatiblePlugin) {
            this.compatible.add((Object)compatiblePlugin);
            return this;
        }

        public Builder addUpdateRequired(Plugin updateRequiredPlugin) {
            this.updateRequired.add((Object)updateRequiredPlugin);
            return this;
        }

        public Builder addUpdateRequiredAfterProductUpdate(Plugin updateRequiredAfterProductUpdatePlugin) {
            this.updateRequiredAfterProductUpdate.add((Object)updateRequiredAfterProductUpdatePlugin);
            return this;
        }

        public Builder addIncompatible(Plugin incompatiblePlugin) {
            this.incompatible.add((Object)incompatiblePlugin);
            return this;
        }

        public Builder addUnknown(Plugin unknownPlugin) {
            this.unknown.add((Object)unknownPlugin);
            return this;
        }

        public ProductUpdatePluginCompatibility build() {
            return new ProductUpdatePluginCompatibility(this);
        }
    }
}

