/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.topology;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.util.Option;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import org.joda.time.DateTime;

public class InstanceTopology {
    private final String serverId;
    private final String instanceName;
    private final URI instanceUrl;
    private final Option<String> cloud;
    private final String platformVersion;
    private final String client;
    private final String clientVersion;
    private final Iterable<InstanceTopologyProduct> productLicenses;
    private final Iterable<InstanceTopologyAddon> addonLicenses;
    private final int totalActiveUsers;
    private final int totalLicensedUsers;

    InstanceTopology(String serverId, String instanceName, URI instanceUrl, Option<String> cloud, String platformVersion, String client, String clientVersion, Iterable<InstanceTopologyProduct> productLicenses, Iterable<InstanceTopologyAddon> addonLicenses, int totalActiveUsers, int totalLicensedUsers) {
        this.serverId = serverId;
        this.instanceName = instanceName;
        this.instanceUrl = instanceUrl;
        this.cloud = cloud;
        this.platformVersion = platformVersion;
        this.client = client;
        this.clientVersion = clientVersion;
        this.productLicenses = ImmutableList.copyOf(productLicenses);
        this.addonLicenses = ImmutableList.copyOf(addonLicenses);
        this.totalActiveUsers = totalActiveUsers;
        this.totalLicensedUsers = totalLicensedUsers;
    }

    public String getServerId() {
        return this.serverId;
    }

    public Iterable<InstanceTopologyProduct> getProductLicenses() {
        return this.productLicenses;
    }

    public Iterable<InstanceTopologyAddon> getAddonLicenses() {
        return this.addonLicenses;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Option<String> getCloud() {
        return this.cloud;
    }

    public URI getInstanceUrl() {
        return this.instanceUrl;
    }

    public int getTotalActiveUsers() {
        return this.totalActiveUsers;
    }

    public int getTotalLicensedUsers() {
        return this.totalLicensedUsers;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getClient() {
        return this.client;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public static enum InstanceTopologyEditionType {
        REMOTE_AGENT_COUNT("remote-agent-count"),
        ROLE_COUNT("role-count"),
        USER_COUNT("user-count");

        private final String key;

        private InstanceTopologyEditionType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum InstanceTopologyLicenseType {
        ACADEMIC("academic"),
        COMMERCIAL("commercial"),
        DEVELOPER("developer");

        private final String key;

        private InstanceTopologyLicenseType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class InstanceTopologyLicense {
        private final String sen;
        private final String key;
        private final String name;
        private final boolean eval;
        private final boolean installed;
        private final InstanceTopologyLicenseType licenseType;
        private final InstanceTopologyEditionType editionType;
        private final Option<String> version;
        private final boolean dataCenter;
        private final int activeUsers;
        private final int licensedUsers;
        private final DateTime purchaseDate;

        public InstanceTopologyLicense(String sen, String key, String name, boolean eval, boolean installed, InstanceTopologyLicenseType licenseType, InstanceTopologyEditionType editionType, Option<String> version, boolean dataCenter, Integer activeUsers, Integer licensedUsers, DateTime purchaseDate) {
            this.sen = sen;
            this.key = key;
            this.name = name;
            this.eval = eval;
            this.installed = installed;
            this.licenseType = licenseType;
            this.editionType = editionType;
            this.version = version;
            this.dataCenter = dataCenter;
            this.activeUsers = activeUsers == null ? 0 : activeUsers;
            this.licensedUsers = licensedUsers == null ? 0 : licensedUsers;
            this.purchaseDate = purchaseDate;
        }

        public String getSen() {
            return this.sen;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEval() {
            return this.eval;
        }

        public boolean isInstalled() {
            return this.installed;
        }

        public Option<String> getVersion() {
            return this.version;
        }

        public boolean isDataCenter() {
            return this.dataCenter;
        }

        public InstanceTopologyLicenseType getLicenseType() {
            return this.licenseType;
        }

        public InstanceTopologyEditionType getEditionType() {
            return this.editionType;
        }

        public int getActiveUsers() {
            return this.activeUsers;
        }

        public int getLicensedUsers() {
            return this.licensedUsers;
        }

        public DateTime getPurchaseDate() {
            return this.purchaseDate;
        }
    }

    public static class InstanceTopologyProduct {
        private final InstanceTopologyLicense license;
        private final String licenseKey;

        public InstanceTopologyProduct(InstanceTopologyLicense license, String licenseKey) {
            this.license = license;
            this.licenseKey = licenseKey;
        }

        public InstanceTopologyLicense getLicense() {
            return this.license;
        }

        public String getLicenseKey() {
            return this.licenseKey;
        }
    }

    public static class InstanceTopologyAddon {
        private final InstanceTopologyLicense license;
        private final boolean valid;
        private final boolean active;
        private final Option<LicenseError> error;

        public InstanceTopologyAddon(InstanceTopologyLicense license, boolean valid, boolean active, Option<LicenseError> error) {
            this.license = license;
            this.valid = valid;
            this.active = active;
            this.error = error;
        }

        public InstanceTopologyLicense getLicense() {
            return this.license;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isActive() {
            return this.active;
        }

        public Option<LicenseError> getError() {
            return this.error;
        }
    }
}

