/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.representations;

import com.atlassian.marketplace.client.api.Page;
import com.atlassian.upm.pac.AvailableAddonWithVersionBase;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.atlassian.upm.rest.representations.AvailablePluginCollectionRepresentation;
import com.atlassian.upm.rest.representations.HostStatusRepresentation;
import com.atlassian.upm.rest.representations.UpmLinkBuilder;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class PurchasedPluginCollectionRepresentation
extends AvailablePluginCollectionRepresentation {
    @JsonProperty
    private final Collection<UnknownPluginEntry> unknownPlugins;
    @JsonProperty
    private final Collection<AvailablePluginCollectionRepresentation.AvailablePluginEntry> incompatiblePlugins;

    @JsonCreator
    public PurchasedPluginCollectionRepresentation(@JsonProperty(value="links") Map<String, URI> links, @JsonProperty(value="linkTemplates") Map<String, String> linkTemplates, @JsonProperty(value="plugins") Collection<AvailablePluginCollectionRepresentation.AvailablePluginEntry> plugins, @JsonProperty(value="hostStatus") HostStatusRepresentation hostStatus, @JsonProperty(value="unknownPlugins") Collection<UnknownPluginEntry> unknownPlugins, @JsonProperty(value="incompatiblePlugins") Collection<AvailablePluginCollectionRepresentation.AvailablePluginEntry> incompatiblePlugins) {
        super(links, linkTemplates, plugins, hostStatus);
        this.unknownPlugins = ImmutableList.copyOf(unknownPlugins);
        this.incompatiblePlugins = ImmutableList.copyOf(incompatiblePlugins);
    }

    public PurchasedPluginCollectionRepresentation(Iterable<AvailableAddonWithVersionBase> plugins, Iterable<AvailableAddonWithVersionBase> incompatiblePlugins, Iterable<String> unknownPluginKeys, UpmUriBuilder uriBuilder, UpmLinkBuilder linkBuilder, HostStatusRepresentation hostStatus, UpmRepresentationFactory representationFactory) {
        super(linkBuilder, plugins, Page.empty(), hostStatus, (java.util.function.Function<? super Integer, URI>)Functions.constant((Object)uriBuilder.buildPurchasedPluginCollectionUri()), (java.util.function.Function<AvailableAddonWithVersionBase, AvailablePluginCollectionRepresentation.AvailablePluginEntry>)PurchasedPluginCollectionRepresentation.entryWithPurchaseDetails(representationFactory), (Map<String, URI>)ImmutableMap.of((Object)"update-licenses", (Object)uriBuilder.buildPurchasedPluginCheckUri()));
        this.incompatiblePlugins = ImmutableList.copyOf((Iterable)Iterables.transform(incompatiblePlugins, PurchasedPluginCollectionRepresentation.entryWithPurchaseDetails(representationFactory)));
        this.unknownPlugins = ImmutableList.copyOf((Iterable)Iterables.transform(unknownPluginKeys, PurchasedPluginCollectionRepresentation.unknownPluginEntry(representationFactory)));
    }

    public Collection<UnknownPluginEntry> getUnknownPlugins() {
        return this.unknownPlugins;
    }

    public Collection<AvailablePluginCollectionRepresentation.AvailablePluginEntry> getIncompatiblePlugins() {
        return this.incompatiblePlugins;
    }

    private static Function<AvailableAddonWithVersionBase, AvailablePluginCollectionRepresentation.AvailablePluginEntry> entryWithPurchaseDetails(UpmRepresentationFactory representationFactory) {
        return a -> representationFactory.createAvailablePluginEntry(a.getAddonBase(), a.getVersionBase());
    }

    private static Function<String, UnknownPluginEntry> unknownPluginEntry(UpmRepresentationFactory representationFactory) {
        return representationFactory::createUnknownPluginEntry;
    }

    public static class UnknownPluginEntry {
        @JsonProperty
        private final String key;
        @JsonProperty
        private final String name;
        @JsonProperty
        private final Map<String, URI> links;

        @JsonCreator
        public UnknownPluginEntry(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="links") Map<String, URI> links) {
            this.key = key;
            this.name = name;
            this.links = ImmutableMap.copyOf(links);
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, URI> getLinks() {
            return this.links;
        }
    }
}

