/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.representations;

import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.atlassian.upm.rest.representations.HostStatusRepresentation;
import com.atlassian.upm.rest.representations.UpmLinkBuilder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ProductUpdatesRepresentation {
    @JsonProperty
    private final Map<String, URI> links;
    @JsonProperty
    private final Collection<ProductUpdateEntry> versions;
    @JsonProperty
    private final HostStatusRepresentation hostStatus;

    @JsonCreator
    public ProductUpdatesRepresentation(@JsonProperty(value="links") Map<String, URI> links, @JsonProperty(value="versions") Collection<ProductUpdateEntry> versions, @JsonProperty(value="safeMode") HostStatusRepresentation hostStatus) {
        this.links = links;
        this.versions = versions;
        this.hostStatus = hostStatus;
    }

    public ProductUpdatesRepresentation(UpmUriBuilder uriBuilder, Iterable<ApplicationVersion> products, UpmLinkBuilder linkBuilder, HostStatusRepresentation hostStatus) {
        this.links = linkBuilder.buildLinksFor(uriBuilder.buildProductUpdatesUri()).build();
        this.versions = ImmutableList.copyOf((Iterable)Iterables.transform(products, this.toEntries(uriBuilder)));
        this.hostStatus = hostStatus;
    }

    public Collection<ProductUpdateEntry> getVersions() {
        return this.versions;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public HostStatusRepresentation getHostStatus() {
        return this.hostStatus;
    }

    private Function<ApplicationVersion, ProductUpdateEntry> toEntries(UpmUriBuilder uriBuilder) {
        return new ToEntryFunction(uriBuilder);
    }

    public static final class ProductUpdateEntry {
        @JsonProperty
        private final String version;
        @JsonProperty
        private final boolean recent;
        @JsonProperty
        private final Map<String, URI> links;

        @JsonCreator
        public ProductUpdateEntry(@JsonProperty(value="version") String version, @JsonProperty(value="recent") boolean recent, @JsonProperty(value="links") Map<String, URI> links) {
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            this.recent = recent;
            this.links = ImmutableMap.copyOf(links);
        }

        public ProductUpdateEntry(ApplicationVersion product, UpmUriBuilder uriBuilder) {
            this.version = product.getName();
            this.recent = ProductUpdateEntry.isRecent(product);
            this.links = ImmutableMap.of((Object)"self", (Object)uriBuilder.buildProductUpdatePluginCompatibilityUri(product.getBuildNumber()));
        }

        public URI getSelf() {
            return this.links.get("self");
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isRecent() {
            return this.recent;
        }

        private static boolean isRecent(ApplicationVersion product) {
            Date releaseDate = product.getReleaseDate().toDateMidnight().toDate();
            return releaseDate == null ? false : new DateTime((Object)releaseDate).isAfter((ReadableInstant)new DateTime().minusWeeks(2));
        }
    }

    private static final class ToEntryFunction
    implements Function<ApplicationVersion, ProductUpdateEntry> {
        private final UpmUriBuilder uriBuilder;

        public ToEntryFunction(UpmUriBuilder uriBuilder) {
            this.uriBuilder = uriBuilder;
        }

        public ProductUpdateEntry apply(ApplicationVersion product) {
            return new ProductUpdateEntry(product, this.uriBuilder);
        }
    }
}

