/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.representations;

import com.atlassian.marketplace.client.model.AddonCategorySummary;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.atlassian.upm.rest.representations.UpmLinkBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class CategoryRepresentation {
    @JsonProperty
    private final Map<String, URI> links;
    @JsonProperty
    private final String name;
    private static final Function<AddonCategorySummary, String> categoryName = AddonCategorySummary::getName;

    @JsonCreator
    public CategoryRepresentation(@JsonProperty(value="links") Map<String, URI> links, @JsonProperty(value="name") String name) {
        this.links = ImmutableMap.copyOf(links);
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    CategoryRepresentation(UpmLinkBuilder linkBuilder, UpmUriBuilder upmUriBuilder, String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.links = linkBuilder.buildLinkForSelf(upmUriBuilder.buildUpmMarketplacePluginCategoryUri(name)).build();
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public String getName() {
        return this.name;
    }

    public static Iterable<CategoryRepresentation> representUniqueCategories(Iterable<AddonCategorySummary> categories, UpmLinkBuilder linkBuilder, UpmUriBuilder uriBuilder) {
        ImmutableSet uniqueNames = ImmutableSet.copyOf((Collection)StreamSupport.stream(categories.spliterator(), false).map(categoryName).collect(Collectors.toList()));
        ImmutableList sortedNames = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).immutableSortedCopy((Iterable)uniqueNames);
        return StreamSupport.stream(sortedNames.spliterator(), false).map(name -> new CategoryRepresentation(linkBuilder, uriBuilder, (String)name)).collect(Collectors.toList());
    }
}

