/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.monitor.resources;

import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.permission.PermissionService;
import com.atlassian.upm.core.permission.UserAttributes;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.rest.monitor.representations.MonitorRepresentationFactory;
import com.atlassian.upm.rest.monitor.representations.PluginStateCollectionRep;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/monitor/installed")
@WebSudoNotRequired
public class InstalledPluginsStateResource {
    private final MonitorRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;
    private final PermissionService permissionService;
    private final PluginRetriever pluginRetriever;

    public InstalledPluginsStateResource(MonitorRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer, PermissionService permissionService, PluginRetriever pluginRetriever) {
        this.representationFactory = (MonitorRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.permissionService = (PermissionService)Preconditions.checkNotNull((Object)permissionService, (Object)"permissionService");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
    }

    @GET
    @Produces(value={"application/json"})
    public PluginStateCollectionRep get(@QueryParam(value="onlyProblems") boolean onlyProblems) {
        this.permissionEnforcer.enforcePermission(Permission.MONITOR_PLUGINS_STATE);
        Iterable plugins = Iterables.filter(this.pluginRetriever.getPlugins(), this.filterPlugins(onlyProblems));
        PluginStateCollectionRep rep = this.representationFactory.createPluginStateCollectionRep(plugins);
        return rep;
    }

    private Predicate<Plugin> filterPlugins(boolean onlyProblems) {
        return onlyProblems ? this.pluginIsDisabledButAdminCannotDisable() : Predicates.alwaysTrue();
    }

    private Predicate<Plugin> pluginIsDisabledButAdminCannotDisable() {
        return new Predicate<Plugin>(){

            public boolean apply(Plugin p) {
                return !p.isEnabled() && InstalledPluginsStateResource.this.permissionService.getPermissionError(UserAttributes.ADMIN_USER, Permission.MANAGE_PLUGIN_ENABLEMENT, p).isDefined();
            }
        };
    }
}

