/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.license.event.PluginLicenseExpiredEvent;
import com.atlassian.upm.core.ApplicationPluginsManager;
import com.atlassian.upm.core.LicensingUsageVerifier;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.license.PluginLicenses;
import com.atlassian.upm.license.internal.PluginLicenseGlobalEvent;
import com.atlassian.upm.license.internal.PluginLicenseGlobalEventPublisher;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.license.internal.PluginLicensesInternal;
import com.atlassian.upm.license.internal.event.PluginLicenseEventPublisherRegistry;
import com.atlassian.upm.lifecycle.UpmProductDataStartupComponent;
import com.atlassian.upm.notification.NotificationCache;
import com.atlassian.upm.notification.NotificationType;
import com.atlassian.upm.notification.PluginLicenseNotificationChecker;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.DisposableBean;

public class PluginLicenseNotificationCheckerImpl
implements PluginLicenseNotificationChecker,
PluginLicenseGlobalEventPublisher,
UpmProductDataStartupComponent,
DisposableBean {
    private final NotificationCache cache;
    private final PluginLicenseRepository licenseRepository;
    private final PluginRetriever pluginRetriever;
    private final PluginLicenseEventPublisherRegistry registry;
    private final LicensingUsageVerifier licensingUsageVerifier;
    private final ApplicationPluginsManager applicationPluginsManager;

    public PluginLicenseNotificationCheckerImpl(NotificationCache cache, PluginLicenseRepository licenseRepository, PluginRetriever pluginRetriever, PluginLicenseEventPublisherRegistry registry, LicensingUsageVerifier licensingUsageVerifier, ApplicationPluginsManager applicationPluginsManager) {
        this.cache = (NotificationCache)Preconditions.checkNotNull((Object)cache, (Object)"cache");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.registry = (PluginLicenseEventPublisherRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry");
        this.licensingUsageVerifier = (LicensingUsageVerifier)Preconditions.checkNotNull((Object)licensingUsageVerifier, (Object)"licensingUsageVerifier");
        this.applicationPluginsManager = (ApplicationPluginsManager)Preconditions.checkNotNull((Object)applicationPluginsManager, (Object)"applicationPluginsManager");
    }

    @Override
    public void onStartupWithProductData() {
        this.registry.registerGlobal(this);
    }

    public void destroy() throws Exception {
        this.registry.unregisterGlobal(this);
    }

    @Override
    public void publish(PluginLicenseEvent event) {
        if (!(event instanceof PluginLicenseExpiredEvent)) {
            this.updateLocalPluginLicenseNotifications();
        }
    }

    @Override
    public void publishGlobal(PluginLicenseGlobalEvent event) {
    }

    @Override
    public void updateLocalPluginLicenseNotifications() {
        Set<String> appPluginKeys = this.applicationPluginsManager.getApplicationRelatedPluginKeys();
        ImmutableList licenses = ImmutableList.copyOf((Collection)StreamSupport.stream(this.licenseRepository.getPluginLicenses().spliterator(), false).filter(arg_0 -> ((com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.compose((com.google.common.base.Predicate)Predicates.in(appPluginKeys), PluginLicenses.licensePluginKey()))).apply(arg_0)).collect(Collectors.toList()));
        this.cache.setNotifications(NotificationType.EDITION_MISMATCH_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, (Predicate<PluginLicense>)PluginLicensesInternal.isEditionMismatch()));
        this.cache.setNotifications(NotificationType.EXPIRED_EVALUATION_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, (Predicate<PluginLicense>)PluginLicensesInternal.isRecentlyExpiredEvaluation(this.pluginRetriever, this.licensingUsageVerifier)));
        this.cache.setNotifications(NotificationType.NEARLY_EXPIRED_EVALUATION_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, (Predicate<PluginLicense>)PluginLicensesInternal.isNearlyExpiredEvaluation(this.pluginRetriever, this.licensingUsageVerifier)));
        this.cache.setNotifications(NotificationType.MAINTENANCE_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, (Predicate<PluginLicense>)PluginLicensesInternal.isMaintenanceRecentlyExpired(this.pluginRetriever, this.licensingUsageVerifier)));
        this.cache.setNotifications(NotificationType.MAINTENANCE_NEARLY_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, (Predicate<PluginLicense>)PluginLicensesInternal.isMaintenanceNearlyExpired(this.pluginRetriever, this.licensingUsageVerifier)));
        this.cache.setNotifications(NotificationType.DATA_CENTER_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, (Predicate<PluginLicense>)PluginLicensesInternal.isDataCenterLicenseRecentlyExpired(this.pluginRetriever, this.licensingUsageVerifier)));
        this.cache.setNotifications(NotificationType.DATA_CENTER_NEARLY_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, (Predicate<PluginLicense>)PluginLicensesInternal.isDataCenterLicenseNearlyExpired(this.pluginRetriever, this.licensingUsageVerifier)));
        DateTime recentExpirationThreshold = new DateTime().minusDays(1);
        for (PluginLicense expiredLicense : StreamSupport.stream(licenses.spliterator(), false).filter(arg_0 -> PluginLicenses.hasError(LicenseError.EXPIRED).apply(arg_0)).collect(Collectors.toList())) {
            for (DateTime expiryDate : expiredLicense.getExpiryDate()) {
                if (expiryDate.isBefore((ReadableInstant)recentExpirationThreshold)) continue;
                this.registry.publishEvent(new PluginLicenseExpiredEvent(expiredLicense, expiryDate));
            }
        }
    }

    private Iterable<String> pluginKeys(Iterable<PluginLicense> licenses, Predicate<PluginLicense> condition) {
        Iterable filteredLicenses = StreamSupport.stream(licenses.spliterator(), false).filter(condition).collect(Collectors.toList());
        return ImmutableList.copyOf((Collection)StreamSupport.stream(filteredLicenses.spliterator(), false).map(PluginLicensesInternal.toPluginKey()).collect(Collectors.toList()));
    }
}

