/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail.impl;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.core.impl.NamespacedPluginSettings;
import com.atlassian.upm.mail.EmailType;
import com.atlassian.upm.mail.LicenseEmailStore;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSettingsLicenseEmailStore
implements LicenseEmailStore {
    public static final String KEY_PREFIX = PluginSettingsLicenseEmailStore.class.getName();
    private static final String LICENSE_EMAILS = "license-emails_v2";
    private static final Logger log = LoggerFactory.getLogger(PluginSettingsLicenseEmailStore.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ObjectMapper mapper;
    private Function<String, Option<LicenseEmailRepresentation>> toLicenseEmailRepresentation = new Function<String, Option<LicenseEmailRepresentation>>(){

        public Option<LicenseEmailRepresentation> apply(String from) {
            try {
                return Option.some(PluginSettingsLicenseEmailStore.this.mapper.readValue(from, LicenseEmailRepresentation.class));
            }
            catch (IOException e) {
                log.warn("Failed to parse LicenseEmailRepresentation from JSON string: " + from, (Throwable)e);
                return Option.none();
            }
        }
    };
    private Function<LicenseEmailRepresentation, Option<String>> fromLicenseEmailRepresentation = new Function<LicenseEmailRepresentation, Option<String>>(){

        public Option<String> apply(LicenseEmailRepresentation from) {
            try {
                return Option.some(PluginSettingsLicenseEmailStore.this.mapper.writeValueAsString((Object)from));
            }
            catch (IOException e) {
                log.warn("Failed to save LicenseEmailRepresentation from JSON string: " + from, (Throwable)e);
                return Option.none();
            }
        }
    };
    private Predicate<LicenseEmailRepresentation> olderThanADay = new Predicate<LicenseEmailRepresentation>(){

        public boolean apply(LicenseEmailRepresentation input) {
            DateTime dayAgo = new DateTime().minusDays(1);
            return new DateTime((Object)input.getDateSent()).isBefore((ReadableInstant)dayAgo);
        }
    };

    public PluginSettingsLicenseEmailStore(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.mapper = new ObjectMapper((JsonFactory)new MappingJsonFactory());
    }

    Iterable<LicenseEmailRepresentation> getLicenseEmails() {
        Object entries = this.getPluginSettings().get(LICENSE_EMAILS);
        if (entries == null) {
            return new ArrayList<LicenseEmailRepresentation>();
        }
        if (!(entries instanceof List)) {
            log.error("Invalid license emails storage has been detected: " + entries);
            this.saveEntries((Iterable<LicenseEmailRepresentation>)ImmutableList.of());
            return new ArrayList<LicenseEmailRepresentation>();
        }
        return Options.catOptions(Iterables.transform((Iterable)((List)entries), this.toLicenseEmailRepresentation));
    }

    @Override
    public boolean emailHasBeenSentToday(UserKey userKey, EmailType emailType, PluginLicense pluginLicense) {
        return Iterables.any(this.getLicenseEmails(), this.emailWithinADay(userKey, emailType, pluginLicense.getPluginKey()));
    }

    private Predicate<LicenseEmailRepresentation> emailWithinADay(final UserKey userKey, final EmailType emailType, final String pluginKey) {
        return new Predicate<LicenseEmailRepresentation>(){

            public boolean apply(LicenseEmailRepresentation email) {
                if (email.getUserKey().equals(userKey.getStringValue()) && email.getEmailType().equals(emailType.toString()) && email.getPluginKey().equals(pluginKey)) {
                    DateTime dayAgo = new DateTime().minusDays(1);
                    return new DateTime((Object)email.getDateSent()).isAfter((ReadableInstant)dayAgo);
                }
                return false;
            }
        };
    }

    @Override
    public void markEmailAsSent(UserKey userKey, EmailType emailType, PluginLicense pluginLicense) {
        this.markEmailAsSent(userKey, emailType, pluginLicense, new Date());
    }

    protected void markEmailAsSent(UserKey userKey, EmailType emailType, PluginLicense pluginLicense, Date date) {
        Iterable<LicenseEmailRepresentation> licenseEmails = this.getLicenseEmails();
        ImmutableList newList = ImmutableList.builder().addAll(licenseEmails).add((Object)new LicenseEmailRepresentation(userKey.getStringValue(), pluginLicense.getPluginKey(), emailType.toString(), date)).build();
        this.saveEntries((Iterable<LicenseEmailRepresentation>)newList);
    }

    @Override
    public void cleanupOldLicenseEmails() {
        this.saveEntries(Iterables.filter(this.getLicenseEmails(), (Predicate)Predicates.not(this.olderThanADay)));
    }

    private void saveEntries(Iterable<LicenseEmailRepresentation> licenseEmails) {
        this.getPluginSettings().put(LICENSE_EMAILS, (Object)Lists.newArrayList(Options.catOptions(Iterables.transform(licenseEmails, this.fromLicenseEmailRepresentation))));
    }

    private PluginSettings getPluginSettings() {
        return new NamespacedPluginSettings(this.pluginSettingsFactory.createGlobalSettings(), KEY_PREFIX);
    }

    public static final class LicenseEmailRepresentation {
        @JsonProperty
        private final String userKey;
        @JsonProperty
        private final String pluginKey;
        @JsonProperty
        private final String emailType;
        @JsonProperty
        private final Date dateSent;

        @JsonCreator
        public LicenseEmailRepresentation(@JsonProperty(value="userKey") String userKey, @JsonProperty(value="pluginKey") String pluginKey, @JsonProperty(value="emailType") String emailType, @JsonProperty(value="dateSent") Date dateSent) {
            this.userKey = userKey;
            this.pluginKey = pluginKey;
            this.emailType = emailType;
            this.dateSent = dateSent;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getEmailType() {
            return this.emailType;
        }

        public Date getDateSent() {
            return this.dateSent;
        }
    }
}

