/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.upm.api.util.Option;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.mail.Multipart;

public class UpmEmail {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    private final String subject;
    private final Set<String> to;
    private final Option<String> from;
    private final Option<String> fromName;
    private final Set<String> cc;
    private final Set<String> bcc;
    private final Set<String> replyTo;
    private final Option<String> inReplyTo;
    private final String body;
    private final Option<String> mimeType;
    private final Option<String> encoding;
    private final Option<Multipart> multipart;
    private final Option<String> messageId;
    private final Map<String, String> headers;

    private UpmEmail(Builder builder) {
        this.to = builder.to.build();
        this.subject = builder.subject;
        this.from = builder.from;
        this.fromName = builder.fromName;
        this.cc = builder.cc.build();
        this.bcc = builder.bcc.build();
        this.replyTo = builder.replyTo.build();
        this.inReplyTo = builder.inReplyTo;
        this.body = builder.body;
        this.mimeType = builder.mimeType;
        this.encoding = builder.encoding;
        this.multipart = builder.multipart;
        this.messageId = builder.messageId;
        this.headers = builder.headers.build();
    }

    public static Builder builder(String subject, String body) {
        return new Builder(subject, body);
    }

    public String getSubject() {
        return this.subject;
    }

    public Set<String> getTo() {
        return this.to;
    }

    public Option<String> getFrom() {
        return this.from;
    }

    public Option<String> getFromName() {
        return this.fromName;
    }

    public Set<String> getCc() {
        return this.cc;
    }

    public Set<String> getBcc() {
        return this.bcc;
    }

    public Set<String> getReplyTo() {
        return this.replyTo;
    }

    public Option<String> getInReplyTo() {
        return this.inReplyTo;
    }

    public String getBody() {
        return this.body;
    }

    public Option<String> getMimeType() {
        return this.mimeType;
    }

    public Option<String> getEncoding() {
        return this.encoding;
    }

    public Option<Multipart> getMultipart() {
        return this.multipart;
    }

    public Option<String> getMessageId() {
        return this.messageId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getMimeTypeAndEncoding() {
        String mimeType = this.mimeType.getOrElse(DEFAULT_MIME_TYPE);
        String encoding = this.encoding.getOrElse(DEFAULT_ENCODING);
        return mimeType + "; charset=" + encoding;
    }

    public static enum Format {
        HTML("text/html"),
        TEXT("text/plain");

        private final String mimeType;

        private Format(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    public static final class Builder {
        private String subject;
        private ImmutableSet.Builder<String> to = ImmutableSet.builder();
        private Option<String> from = Option.none();
        private Option<String> fromName = Option.none();
        private ImmutableSet.Builder<String> cc = ImmutableSet.builder();
        private ImmutableSet.Builder<String> bcc = ImmutableSet.builder();
        private ImmutableSet.Builder<String> replyTo = ImmutableSet.builder();
        private Option<String> inReplyTo = Option.none();
        private String body;
        private Option<String> mimeType = Option.none();
        private Option<String> encoding = Option.none();
        private Option<Multipart> multipart = Option.none();
        private Option<String> messageId = Option.none();
        private ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();

        public Builder(String subject, String body) {
            this.subject = (String)Preconditions.checkNotNull((Object)subject, (Object)"subject");
            this.body = (String)Preconditions.checkNotNull((Object)body, (Object)"body");
        }

        public Builder addTo(String to) {
            this.to.add((Object)to);
            return this;
        }

        public Builder addTo(Set<String> to) {
            this.to.addAll(to);
            return this;
        }

        public Builder from(String from) {
            this.from = Option.some(from);
            return this;
        }

        public Builder fromName(Option<String> fromName) {
            this.fromName = fromName;
            return this;
        }

        public Builder addCc(String cc) {
            this.cc.add((Object)cc);
            return this;
        }

        public Builder addBcc(String bcc) {
            this.bcc.add((Object)bcc);
            return this;
        }

        public Builder addReplyTo(String replyTo) {
            this.replyTo.add((Object)replyTo);
            return this;
        }

        public Builder inReplyTo(Option<String> inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = Option.some(mimeType);
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = Option.some(encoding);
            return this;
        }

        public Builder multipart(Option<Multipart> multipart) {
            this.multipart = multipart;
            return this;
        }

        public Builder messageId(Option<String> messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put((Object)key, (Object)value);
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.headers.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return this;
        }

        public UpmEmail build() {
            return new UpmEmail(this);
        }
    }
}

