/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.LicensingUsageVerifier;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.license.LicensedPlugins;
import com.atlassian.upm.license.PluginLicenses;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;

public final class PluginLicensesInternal {
    private PluginLicensesInternal() {
    }

    public static final Function<PluginLicense, String> toPluginKey() {
        return PluginLicense::getPluginKey;
    }

    public static Function<PluginLicense, Option<String>> licensePluginSen() {
        return PluginLicense::getSupportEntitlementNumber;
    }

    public static Predicate<PluginLicense> isEditionMismatch() {
        return Predicates.or(PluginLicenses.hasError(LicenseError.USER_MISMATCH), PluginLicenses.hasError(LicenseError.EDITION_MISMATCH));
    }

    public static Predicate<PluginLicense> isRecentlyExpiredEvaluation(PluginRetriever pluginRetriever, LicensingUsageVerifier licensingUsageVerifier) {
        return Predicates.and(PluginLicensesInternal.isRecentExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, licensingUsageVerifier)));
    }

    public static Predicate<PluginLicense> isRecentlyExpiredEvaluation(Option<Plugin> plugin) {
        return Predicates.and(PluginLicensesInternal.isRecentExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin)));
    }

    private static Predicate<PluginLicense> isRecentExpiredEvaluationCoreLogic() {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicenses.hasError(LicenseError.EXPIRED), PluginLicenses.isRecentlyExpired(), PluginLicenses.isEvaluation()});
    }

    public static Predicate<PluginLicense> isNearlyExpiredEvaluation(PluginRetriever pluginRetriever, LicensingUsageVerifier licensingUsageVerifier) {
        return Predicates.and(PluginLicensesInternal.isNearlyExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, licensingUsageVerifier)));
    }

    public static Predicate<PluginLicense> isNearlyExpiredEvaluation(Option<Plugin> plugin) {
        return Predicates.and(PluginLicensesInternal.isNearlyExpiredEvaluationCoreLogic(), (Predicate)Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin)));
    }

    private static Predicate<PluginLicense> isNearlyExpiredEvaluationCoreLogic() {
        return Predicates.and(PluginLicenses.isNearlyExpired(), PluginLicenses.isEvaluation());
    }

    public static Predicate<PluginLicense> isMaintenanceRecentlyExpired(PluginRetriever pluginRetriever, LicensingUsageVerifier licensingUsageVerifier) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceRecentlyExpiredCoreLogic(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, licensingUsageVerifier))});
    }

    public static Predicate<PluginLicense> isMaintenanceRecentlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceRecentlyExpiredCoreLogic(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    private static Predicate<PluginLicense> isMaintenanceRecentlyExpiredCoreLogic() {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicenses.isRecentlyMaintenanceExpired(), Predicates.not(PluginLicenses.isEvaluation())});
    }

    public static Predicate<PluginLicense> isMaintenanceNearlyExpired(PluginRetriever pluginRetriever, LicensingUsageVerifier licensingUsageVerifier) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, licensingUsageVerifier))});
    }

    public static Predicate<PluginLicense> isMaintenanceNearlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicense::isDataCenter), PluginLicensesInternal.isMaintenanceNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    private static Predicate<PluginLicense> isMaintenanceNearlyExpired() {
        return Predicates.and(PluginLicenses.isNearlyMaintenanceExpired(), (Predicate)Predicates.not(PluginLicenses.isEvaluation()));
    }

    private static Predicate<PluginLicense> isLicenseNearlyExpired() {
        return Predicates.and(PluginLicenses.isNearlyExpired(), (Predicate)Predicates.not(PluginLicenses.isEvaluation()));
    }

    private static Predicate<PluginLicense> isLicenseRecentlyExpired() {
        return Predicates.and(PluginLicenses.isRecentlyExpired(), (Predicate)Predicates.not(PluginLicenses.isEvaluation()));
    }

    public static Predicate<PluginLicense> isDataCenterLicenseRecentlyExpired(PluginRetriever pluginRetriever, LicensingUsageVerifier licensingUsageVerifier) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseRecentlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, licensingUsageVerifier))});
    }

    public static Predicate<PluginLicense> isDataCenterLicenseNearlyExpired(PluginRetriever pluginRetriever, LicensingUsageVerifier licensingUsageVerifier) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(pluginRetriever, licensingUsageVerifier))});
    }

    public static Predicate<PluginLicense> isDataCenterLicenseRecentlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseRecentlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    public static Predicate<PluginLicense> isDataCenterLicenseNearlyExpired(Option<Plugin> plugin) {
        return Predicates.and((Predicate[])new Predicate[]{PluginLicense::isDataCenter, PluginLicensesInternal.isLicenseNearlyExpired(), Predicates.not(PluginLicensesInternal.isUninstalledLegacyPlugin(plugin))});
    }

    private static Predicate<PluginLicense> isUninstalledLegacyPlugin(PluginRetriever pluginRetriever, LicensingUsageVerifier licensingUsageVerifier) {
        return license -> {
            String pluginKey = license.getPluginKey();
            if (!LicensedPlugins.isLegacyLicensePlugin(pluginKey)) {
                return false;
            }
            Iterator<Plugin> iterator = pluginRetriever.getPlugin(pluginKey).iterator();
            if (iterator.hasNext()) {
                Plugin plugin = iterator.next();
                return !LicensedPlugins.usesLicensing(plugin.getPlugin(), licensingUsageVerifier);
            }
            return true;
        };
    }

    public static Predicate<PluginLicense> isUninstalledLegacyPlugin(Option<Plugin> plugin) {
        return license -> {
            String pluginKey = license.getPluginKey();
            if (!LicensedPlugins.isLegacyLicensePlugin(pluginKey)) {
                return false;
            }
            return !plugin.isDefined();
        };
    }
}

