/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.analytics.event;

import com.atlassian.upm.analytics.event.UpmAnalyticsEvent;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;

public class VendorFeedbackEvent
extends UpmAnalyticsEvent {
    private final Map<String, String> metadata;
    private final String eventType;

    public VendorFeedbackEvent(String pluginKey, String reasonCode, String message, String type, String pluginVersion, Option<String> email, Option<String> fullName, Option<String> addonSen) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"pk", (Object)pluginKey);
        builder.put((Object)"pv", (Object)pluginVersion);
        builder.put((Object)"reasonCode", (Object)reasonCode);
        builder.put((Object)"message", (Object)message);
        for (String e : email) {
            builder.put((Object)"email", (Object)e);
        }
        for (String n : fullName) {
            builder.put((Object)"fullName", (Object)n);
        }
        for (String s : addonSen) {
            builder.put((Object)"addonSen", (Object)s);
        }
        this.metadata = builder.build();
        this.eventType = "vendor-feedback-" + type;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public Iterable<Pair<String, String>> getInvolvedPluginVersions() {
        return ImmutableList.of();
    }

    @Override
    public Iterable<Pair<String, String>> getMetadata() {
        return this.metadata.entrySet().stream().map(e -> Pair.pair(e.getKey(), e.getValue())).collect(Collectors.toList());
    }
}

