/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.filepermission;

import com.atlassian.dc.filestore.api.security.policy.FilePermissionPolicy;
import com.atlassian.dc.filestore.api.security.scheme.FilePermissionScheme;
import com.atlassian.dc.filestore.api.security.scheme.SchemePath;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilePermissionSchemes {
    private FilePermissionSchemes() {
    }

    public static FilePermissionScheme merge(List<FilePermissionScheme> schemes) {
        HashMap<SchemePath, FilePermissionPolicy> mergedPolicies = new HashMap<SchemePath, FilePermissionPolicy>();
        HashMap<SchemePath, Set<Integer>> policySources = new HashMap<SchemePath, Set<Integer>>();
        for (int schemeIndex = 0; schemeIndex < schemes.size(); ++schemeIndex) {
            FilePermissionScheme scheme = schemes.get(schemeIndex);
            for (Map.Entry entry : scheme.directoryPolicies().entrySet()) {
                SchemePath path = (SchemePath)entry.getKey();
                FilePermissionPolicy policy = (FilePermissionPolicy)entry.getValue();
                if (mergedPolicies.containsKey(path)) {
                    FilePermissionPolicy mergedPolicy = FilePermissionSchemes.mergePolicies((FilePermissionPolicy)mergedPolicies.get(path), policy);
                    mergedPolicies.put(path, mergedPolicy);
                    ((Set)policySources.get(path)).add(schemeIndex);
                    continue;
                }
                mergedPolicies.put(path, policy);
                policySources.put(path, new HashSet<Integer>(Set.of(Integer.valueOf(schemeIndex))));
            }
        }
        Map<SchemePath, FilePermissionPolicy> result = FilePermissionSchemes.applyHierarchicalInheritance(mergedPolicies, policySources);
        return () -> result;
    }

    private static FilePermissionPolicy mergePolicies(FilePermissionPolicy policy1, FilePermissionPolicy policy2) {
        return new MergedFilePermissionPolicy(FilePermissionSchemes.intersectSets(policy1.readableBy(), policy2.readableBy()), FilePermissionSchemes.intersectSets(policy1.writableBy(), policy2.writableBy()), FilePermissionSchemes.intersectSets(policy1.executableBy(), policy2.executableBy()));
    }

    private static <T> Set<T> intersectSets(Set<T> set1, Set<T> set2) {
        HashSet<T> intersection = new HashSet<T>(set1);
        intersection.retainAll(set2);
        return intersection;
    }

    private static Map<SchemePath, FilePermissionPolicy> applyHierarchicalInheritance(Map<SchemePath, FilePermissionPolicy> mergedPolicies, Map<SchemePath, Set<Integer>> policySources) {
        HashMap<SchemePath, FilePermissionPolicy> result = new HashMap<SchemePath, FilePermissionPolicy>(mergedPolicies);
        List<SchemePath> sortedPaths = mergedPolicies.keySet().stream().sorted(Comparator.comparing(path -> path.getNormalizedPath().toString())).toList();
        for (int i = 1; i < sortedPaths.size(); ++i) {
            Set<Integer> parentSources;
            boolean shouldInherit;
            SchemePath currentPath = sortedPaths.get(i);
            String currentPathStr = currentPath.getNormalizedPath().toString();
            SchemePath immediateParent = null;
            for (int j = i - 1; j >= 0; --j) {
                SchemePath potentialParentPath = sortedPaths.get(j);
                String potentialParentStr = potentialParentPath.getNormalizedPath().toString();
                if (!currentPathStr.startsWith(potentialParentStr + File.separator)) continue;
                immediateParent = potentialParentPath;
                break;
            }
            if (immediateParent == null) continue;
            Set<Integer> currentSources = policySources.get(currentPath);
            boolean bl = shouldInherit = !currentSources.equals(parentSources = policySources.get(immediateParent));
            if (!shouldInherit) continue;
            FilePermissionPolicy currentPolicy = (FilePermissionPolicy)result.get(currentPath);
            FilePermissionPolicy parentPolicy = (FilePermissionPolicy)result.get(immediateParent);
            FilePermissionPolicy inheritedPolicy = FilePermissionSchemes.mergePolicies(currentPolicy, parentPolicy);
            result.put(currentPath, inheritedPolicy);
        }
        return result;
    }

    private record MergedFilePermissionPolicy(Set<FilePermissionPolicy.Principal> readableBy, Set<FilePermissionPolicy.Principal> writableBy, Set<FilePermissionPolicy.Principal> executableBy) implements FilePermissionPolicy
    {
    }
}

