/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.filepermission;

import com.atlassian.dc.filestore.api.security.scheme.FilePermissionScheme;
import com.atlassian.dc.filestore.api.security.validation.FilePermissionSchemeValidator;
import com.atlassian.dc.filestore.api.security.validation.FilePrincipal;
import com.atlassian.dc.filestore.api.security.validation.ValidationFinding;
import com.atlassian.dc.filestore.api.security.validation.ValidationFindingDetails;
import com.atlassian.dc.filestore.api.security.validation.ValidationResult;
import com.atlassian.dc.filestore.security.validation.DefaultPermissionSchemeValidator;
import com.atlassian.dc.filestore.security.validation.ValidationResultPrinter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthStatus;
import com.atlassian.troubleshooting.healthcheck.SupportHealthStatusBuilder;
import com.atlassian.troubleshooting.healthcheck.checks.filepermission.FilePermissionHealthCheckSchemesProvider;
import com.atlassian.troubleshooting.healthcheck.checks.filepermission.FilePermissionSchemes;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePermissionHealthCheck
implements SupportHealthCheck {
    private static final String HEALTHCHECK_MAX_ISSUES_PROPERTY = "healthcheck.filepermission.max.issues";
    private static final int DEFAULT_MAX_ISSUES = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePermissionHealthCheck.class);
    private final FilePermissionHealthCheckSchemesProvider filePermissionServiceProvider;
    private final SupportHealthStatusBuilder healthStatusBuilder;
    private final I18nResolver i18nHelper;
    private final ClusterService clusterService;

    public FilePermissionHealthCheck(FilePermissionHealthCheckSchemesProvider filePermissionServiceProvider, SupportHealthStatusBuilder healthStatusBuilder, I18nResolver i18nHelper, ClusterService clusterService) {
        this.filePermissionServiceProvider = filePermissionServiceProvider;
        this.healthStatusBuilder = healthStatusBuilder;
        this.i18nHelper = i18nHelper;
        this.clusterService = clusterService;
    }

    @Override
    public boolean isNodeSpecific() {
        return true;
    }

    @Override
    public SupportHealthStatus check() {
        List<FilePermissionScheme> schemes = this.filePermissionServiceProvider.getSchemes();
        if (schemes.isEmpty()) {
            return this.healthStatusBuilder.disabled(this, "healthcheck.filepermission.ok", new Serializable[0]);
        }
        FilePermissionScheme mergedScheme = FilePermissionSchemes.merge(schemes);
        ValidationResult result = this.getValidator().validate(mergedScheme);
        if (result.isValid()) {
            return this.getOkHealthStatus();
        }
        this.getResultPrinter().print(mergedScheme, result, false);
        return this.processFindings(result.getFindings());
    }

    FilePermissionSchemeValidator getValidator() {
        return new DefaultPermissionSchemeValidator();
    }

    ValidationResultPrinter getResultPrinter() {
        return new ValidationResultPrinter(arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    private String getNodeId() {
        return this.clusterService.getCurrentNodeId().orElse(null);
    }

    private SupportHealthStatus getOkHealthStatus() {
        if (this.clusterService.isClustered()) {
            return this.healthStatusBuilder.ok(this, "healthcheck.filepermission.ok.cluster", new Serializable[]{this.getNodeId()});
        }
        return this.healthStatusBuilder.ok(this, "healthcheck.filepermission.ok", new Serializable[0]);
    }

    private SupportHealthStatus processFindings(List<ValidationFinding> findings) {
        if (findings.isEmpty()) {
            return this.getOkHealthStatus();
        }
        if (findings.size() <= FilePermissionHealthCheck.getMaxIssuesToDisplay()) {
            return this.buildHealthStatusWithListOfIssues(findings);
        }
        return this.buildHealthStatusWithIssuesGroupedByDirectory(findings);
    }

    private static int getMaxIssuesToDisplay() {
        String value = System.getProperty(HEALTHCHECK_MAX_ISSUES_PROPERTY);
        if (value != null) {
            try {
                int parsed = Integer.parseInt(value);
                if (parsed > 0) {
                    return parsed;
                }
            }
            catch (NumberFormatException ignored) {
                LOGGER.error("Invalid value for property {}: {} - expected number", (Object)HEALTHCHECK_MAX_ISSUES_PROPERTY, (Object)value);
            }
        }
        return 10;
    }

    private SupportHealthStatus buildHealthStatusWithListOfIssues(List<ValidationFinding> findings) {
        String message = findings.stream().map(finding -> "\u2022 " + finding.getFilePath().toString() + ": " + this.composeFindingDetailsMessage(finding.getFindingDetails())).collect(Collectors.joining("\n"));
        if (this.clusterService.isClustered()) {
            return this.healthStatusBuilder.major(this, "healthcheck.filepermission.issues.cluster", new Serializable[]{message, this.getNodeId()});
        }
        return this.healthStatusBuilder.major(this, "healthcheck.filepermission.issues", new Serializable[]{message});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String composeFindingDetailsMessage(ValidationFindingDetails details) {
        FilePrincipal principal;
        FilePrincipal enumKey2;
        if (details instanceof ValidationFindingDetails.Simple) {
            ValidationFindingDetails.Simple simpleDetails = (ValidationFindingDetails.Simple)details;
            String enumKey2 = simpleDetails.name().toLowerCase().replace('_', '.');
            return this.i18nHelper.getText("healthcheck.filepermission.finding.simple." + enumKey2);
        }
        if (!(details instanceof ValidationFindingDetails.AccessViolation)) return this.i18nHelper.getText("healthcheck.filepermission.finding.unknown");
        ValidationFindingDetails.AccessViolation accessViolation = (ValidationFindingDetails.AccessViolation)details;
        try {
            principal = enumKey2 = accessViolation.principal();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        FilePrincipal operation = enumKey2 = accessViolation.operation();
        String i18nKeyPrefix = "healthcheck.filepermission.finding.access.violation." + operation.name().toLowerCase();
        if (principal instanceof FilePrincipal.User) {
            String string;
            FilePrincipal.User user = (FilePrincipal.User)principal;
            String name = string = user.name();
            return this.i18nHelper.getText(i18nKeyPrefix + ".user", new Serializable[]{name});
        }
        if (principal instanceof FilePrincipal.Group) {
            String string;
            FilePrincipal.Group group = (FilePrincipal.Group)principal;
            String name = string = group.name();
            return this.i18nHelper.getText(i18nKeyPrefix + ".group", new Serializable[]{name});
        }
        if (!(principal instanceof FilePrincipal.Everyone)) return this.i18nHelper.getText("healthcheck.filepermission.finding.unknown");
        return this.i18nHelper.getText(i18nKeyPrefix + ".everyone");
    }

    private SupportHealthStatus buildHealthStatusWithIssuesGroupedByDirectory(List<ValidationFinding> findings) {
        Map groupedFindings = findings.stream().collect(Collectors.groupingBy(finding -> finding.getPath().getNormalizedPath().toString(), Collectors.toList()));
        String message = groupedFindings.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            List findingsInDirectory = (List)entry.getValue();
            int issueCount = findingsInDirectory.size();
            return "\u2022 " + (String)entry.getKey() + " - " + this.i18nHelper.getText("healthcheck.filepermission.findings.count", new Serializable[]{Integer.valueOf(issueCount)});
        }).collect(Collectors.joining("\n"));
        if (this.clusterService.isClustered()) {
            return this.healthStatusBuilder.major(this, "healthcheck.filepermission.issues.grouped.cluster", new Serializable[]{Integer.valueOf(findings.size()), message, this.getNodeId()});
        }
        return this.healthStatusBuilder.major(this, "healthcheck.filepermission.issues.grouped", new Serializable[]{Integer.valueOf(findings.size()), message});
    }
}

