/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.eol;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.troubleshooting.healthcheck.checks.eol.Product;
import com.atlassian.troubleshooting.healthcheck.checks.eol.ProductReleaseDateManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;

@ParametersAreNonnullByDefault
public class DefaultProductReleaseDateManager
implements ProductReleaseDateManager {
    private static final Type PRODUCT_LIST_TYPE = new TypeToken<List<Product>>(){}.getType();

    @Override
    @Nonnull
    public List<Product> readProducts(InputStream stream) {
        List list;
        Gson gson = new GsonBuilder().serializeNulls().setDateFormat("yyyy-MM-dd").create();
        InputStreamReader inputStreamReader = new InputStreamReader(stream);
        try {
            list = (List)gson.fromJson((Reader)inputStreamReader, PRODUCT_LIST_TYPE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStreamReader.close();
        return list;
    }

    @Override
    public void writeProducts(List<Product> products, File jsonFile) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd").create();
        try (FileWriter writer = new FileWriter(jsonFile);){
            gson.toJson(products, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

