/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd.task;

import com.atlassian.troubleshooting.api.ClusterService;
import com.atlassian.troubleshooting.api.PluginInfo;
import com.atlassian.troubleshooting.crowd.ActiveObjectsServiceProvider;
import com.atlassian.troubleshooting.crowd.task.CrowdAoTaskMonitorRepositoryFactory;
import com.atlassian.troubleshooting.stp.persistence.TaskMonitorRepository;
import com.atlassian.troubleshooting.stp.task.AbstractTaskMonitorRepositoryFactory;
import com.atlassian.troubleshooting.stp.task.TaskMonitor;
import com.atlassian.troubleshooting.stp.task.TaskMonitorFactory;
import com.atlassian.troubleshooting.stp.task.TaskMonitorRepositoryFactory;
import com.atlassian.troubleshooting.stp.task.TaskType;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdTaskMonitorRepositoryFactory
implements TaskMonitorRepositoryFactory {
    private final ActiveObjectsServiceProvider activeObjectsServiceProvider;
    private final ClusterService clusterService;
    private final PluginInfo pluginInfo;
    private final TaskMonitorFactory taskMonitorFactory;
    private final TaskMonitorRepositoryFactory localFactory = new AbstractTaskMonitorRepositoryFactory(this){};
    private TaskMonitorRepositoryFactory aoFactory;

    @Autowired
    public CrowdTaskMonitorRepositoryFactory(ActiveObjectsServiceProvider activeObjectsServiceProvider, ClusterService clusterService, PluginInfo pluginInfo, TaskMonitorFactory taskMonitorFactory) {
        this.activeObjectsServiceProvider = Objects.requireNonNull(activeObjectsServiceProvider);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.pluginInfo = Objects.requireNonNull(pluginInfo);
        this.taskMonitorFactory = Objects.requireNonNull(taskMonitorFactory);
    }

    @Override
    public <V extends TaskMonitor<?>> TaskMonitorRepository<V> getRepository(TaskType taskType) {
        Optional<Object> aoOptional = this.activeObjectsServiceProvider.getActiveObjectsService();
        if (aoOptional.isPresent()) {
            if (this.aoFactory == null) {
                this.aoFactory = new CrowdAoTaskMonitorRepositoryFactory(aoOptional.get(), this.clusterService, this.pluginInfo, this.taskMonitorFactory);
            }
            return this.aoFactory.getRepository(taskType);
        }
        return this.localFactory.getRepository(taskType);
    }
}

