/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import com.atlassian.crowd.service.cluster.ClusterMessageService;
import com.atlassian.troubleshooting.crowd.CancelMessage;
import com.atlassian.troubleshooting.crowd.Message;
import com.atlassian.troubleshooting.crowd.RequestMessage;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import com.atlassian.troubleshooting.stp.zip.ClusteredSupportZipService;
import com.atlassian.troubleshooting.stp.zip.SupportZipRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrowdClusteredSupportZipService
implements ClusteredSupportZipService {
    public static final Logger LOGGER = LoggerFactory.getLogger(CrowdClusteredSupportZipService.class);
    public static final String CLUSTER_MESSAGE_CHANNEL = "troubleshooting.support.zip";
    private final ClusterMessageService clusterMessageService;

    @Autowired
    public CrowdClusteredSupportZipService(ClusterMessageService clusterMessageService) {
        this.clusterMessageService = Objects.requireNonNull(clusterMessageService);
    }

    @Override
    @Nonnull
    public Optional<String> requestSupportZipCreationOnOtherNodes(SupportZipRequest supportZipRequest) {
        this.sendMessage(new RequestMessage(supportZipRequest));
        return Optional.empty();
    }

    @Override
    public void requestSupportZipCancellationOnOtherNodes(String taskId) {
        this.sendMessage(new CancelMessage(taskId));
    }

    private void sendMessage(Message message) {
        try {
            ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
            String request = mapper.writeValueAsString((Object)message);
            this.clusterMessageService.publish(CLUSTER_MESSAGE_CHANNEL, request);
        }
        catch (Exception e) {
            LOGGER.error("Failed to send cluster support zip message", (Throwable)e);
        }
    }
}

