/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.rest;

import com.atlassian.troubleshooting.stp.request.SupportRequestService;
import com.atlassian.troubleshooting.stp.rest.CacheControlUtils;
import com.atlassian.troubleshooting.stp.task.TaskMonitor;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="support-request")
@Produces(value={"application/json"})
@Singleton
public class SupportRequestResource {
    private final SupportRequestService supportRequestService;

    @Inject
    public SupportRequestResource(SupportRequestService supportRequestService) {
        this.supportRequestService = supportRequestService;
    }

    @GET
    @Path(value="{id}")
    public Response getSupportZipDetails(@PathParam(value="id") String id) {
        TaskMonitor monitor = this.supportRequestService.getMonitor(id);
        if (monitor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControlUtils.NO_CACHE).build();
        }
        Response.ResponseBuilder builder = Response.ok().entity(monitor.getAttributes());
        if (!monitor.isDone()) {
            builder.cacheControl(CacheControlUtils.NO_CACHE);
        }
        return builder.build();
    }
}

