window.loadHerculesResultTable = function () {
  // Add trigger for Atlassian Analytics when scanner result is clicked
  AJS.$(".scanner-result").click(function () {
    const scanId = AJS.$("#stp-hercules-results").data("scanId");
    const sourceId = AJS.$(this).data("source-id");
    const patternId = AJS.$(this).data("pattern-id");
    const matchCount = AJS.$(this).data("match-count");

    let project = "";
    let pageId = "";

    const pageIdPattern = /\d+/g;

    if (sourceId == "CACKB") {
      // CACKB don't have project, hence put - instead
      project = "-";
      pageId = pageIdPattern.exec(patternId);
    } else if (sourceId === "JAC") {
      const projectKeyPattern = /([A-Z])\w+/g;

      // We need to separate the project key and issue ID, as analytics doesn't seem to accept for issue key
      // After getting the project key, the list of accepted project keys are listed in the stp_whitelist file
      // The issue key is send as pageId here.
      project = projectKeyPattern.exec(patternId);
      pageId = pageIdPattern.exec(patternId);
    }

    AJS.trigger("analyticsEvent", {
      name: "stp.log.analyzer.result.clicked",
      data: {
        scanId,
        source: sourceId,
        project: project[0],
        pageId,
        matchCount,
      },
    });
  });

  // Attach click event handler to the refresh link
  AJS.$("#refresh-scan-result").on("click", function (event) {
    window.rerunHerculesScanViaAjax(event, this);
  });

  window.startPosition =
    AJS.$("#stp-hercules-results").data("startPosition") - 1;
  window.endPosition = AJS.$("#stp-hercules-results").data("endPosition");
  window.numResults = AJS.$("#stp-hercules-results").data("scanResultsCount");
  window.pageSize = 10;
  window.currentPage = 1;
  window.enabledResultFilter = [];

  // Initialize the inline edit function for the log file path field
  window.initInlineEditFn();

  var connectWith = AJS.$('input[name="logFilePath"]');
  var initialValue = connectWith.val();
  var replaceWith = AJS.$(
    '<input name="temp" type="text" id="tempInput" />',
  ).val(initialValue);
  var placeHolder = AJS.$(".stp-log-file-path");

  placeHolder.inlineEdit(replaceWith, connectWith);

  // Insert the priority icons here
  AJS.$(".priority-trivial").attr("title", "Trivial");
  AJS.$(".priority-minor").attr("title", "Minor");
  AJS.$(".priority-major").attr("title", "Major");
  AJS.$(".priority-critical").attr("title", "Critical");
  AJS.$(".priority-blocker").attr("title", "Blocker");

  setViewport();
  initLogAnalyzerControlPanel(true);
  triggerAnalyticsForAllResults();

  AJS.$("#cachedLogFilePath").on("change", function (event) {
    var newPath = AJS.$('input[name="logFilePath"]').val();

    if (initialValue !== newPath) {
      rerunHerculesScanViaAjax(event, this);
    }
  });

  AJS.$("#stp-scanned-file").submit(function (event) {
    var newPath = AJS.$('input[name="temp"]').val();

    if (initialValue !== newPath) {
      // In case if the form is submitted (eg: user keypress 'Enter'),
      // we need to update the logFilePath input field first before rerunning the scan)
      updateInlineEditedField(placeHolder, replaceWith, connectWith);
      rerunHerculesScanViaAjax(event, this);
    }
  });
};
