function setCustomerTimezone() {
  const tzField = document.getElementById("timeZone");
  if (tzField) {
    const offset = new Date().getTimezoneOffset() / 60; // hours from GMT
    if (offset <= 0) {
      tzField.value = `GMT+${-offset}`;
    } else {
      tzField.value = `GMT-${offset}`;
    }
  }
}

function uncheckAllBoxes() {
  AJS.$("#support-zip-modal input:checkbox:checked").each(function () {
    this.checked = false;
  });
  AJS.$("#hidden-zip-fields input:hidden").each(function () {
    this.value = false;
  });
}

function checkAllBoxes() {
  AJS.$("#support-zip-modal input:checkbox:not(:checked)").each(function () {
    this.checked = true;
  });
  AJS.$("#hidden-zip-fields input:hidden").each(function () {
    this.value = true;
  });
}

function submitAnalytics(name) {
  AJS.trigger("analyticsEvent", { name });
}

function createSupportZipModalDialog(e) {
  const dialog = new AJS.Dialog({
    width: 800,
    height: 500,
    id: "support-zip-modal-dialog",
    closeOnOutsideClick: false,
  });

  dialog.addPanel("SinglePanel", AJS.$("#support-zip-modal"));

  dialog.addSubmit(
    "$i18n.getText('stp.create.support.request.support.zip.save')",
    () => {
      e.preventDefault();
      AJS.$("#attach-support-zip").prop("checked", true);

      // Update all the hidden fields with the values from the modal:
      AJS.$("#hidden-zip-fields input:hidden").each(function () {
        const modalField = AJS.$(`#modal-${this.id}`);
        const newValue =
          modalField.prop("type") === "checkbox"
            ? modalField.is(":checked")
            : modalField.val();

        this.value = newValue;
      });

      dialog.hide();
    },
  );

  dialog.addLink(
    "$i18n.getText('stp.create.support.request.support.zip.reset')",
    () => {
      e.preventDefault();
      checkAllBoxes();
    },
  );

  AJS.$("#stp-support-zip-modal-tooltip").tooltip();

  return dialog;
}

window.loadCreateSupportRequestStart =
  function loadCreateSupportRequestStart() {
    const form = AJS.$("#form-create-support-request");
    if (!form.data("mailServerConfigured")) {
      const applicationName = form.data("applicationName");
      const mailServerConfigurationUrl = form.data(
        "mailServerConfigurationUrl",
      );

      form.before(
        window.Stp.Templates.CreateRequest.Templates.noSmtpMailServerConfiguredBanner(
          {
            applicationName,
            mailServerConfigurationUrl,
          },
        ),
      );

      AJS.$("#support-zip-link").on("click", (e) => {
        AJS.$("#tab-support-zip").click();
        e.preventDefault();
      });

      window.attachSmtpMailBannerAnalytics();
    }

    const $attachSupportZipDialog = AJS.dialog2("#attach-support-zip-dialog");

    // Only set the attach support zip checkbox true if the user accepts the modal:
    AJS.$(document).on("click", "#attach-inline-no-button", (e) => {
      e.preventDefault();

      // Set the checkbox to no, and all the checkboxes in the modal:
      AJS.$("#attach-support-zip").prop("checked", false);
      uncheckAllBoxes();
      $attachSupportZipDialog.hide();
      submitAnalytics("stp.get.help.attach.dialog.no");
    });

    AJS.$(document).on("click", "#attach-inline-yes-button", (e) => {
      e.preventDefault();
      $attachSupportZipDialog.hide();
      submitAnalytics("stp.get.help.attach.dialog.yes");
    });

    // On page update we want to reset all the checkboxes.
    AJS.bind(
      "troubleshootingTabUpdated#create-support-request troubleshootingTabLoaded#create-support-request",
      () => {
        checkAllBoxes();
      },
    );

    AJS.$(() => {
      // Initialize the function that will store the create support request form data into browser local storage
      const url = form.data("requestUrl");
      const currentUser = form.data("contactEmail");

      // current user and base URL value is here used to evaluate if the cached banner is relevant to the current
      // instance that the admin is on
      window.createSupportRequestFormData(url, currentUser);
    });

    setCustomerTimezone();

    AJS.toInit(() => {
      AJS.$("#stp-support-zip-tooltip").tooltip();
    });

    AJS.$("#customize-dialog-show-button").click((e) => {
      e.preventDefault();

      let $dialog = AJS.$("#support-zip-modal-dialog");

      // Create the support zip modal dialog if it doesn't exist on the page yet
      if ($dialog.length === 0) {
        $dialog = createSupportZipModalDialog(e);
      }

      $dialog.show();
    });

    // Warn the user if they want to untick the attach support zip:
    AJS.$("#attach-support-zip").change(function (e) {
      e.preventDefault();

      if (AJS.$(this).is(":checked")) {
        // If there are no checkboxes selected, select them all. Otherwise leave them as they are:
        if (AJS.$("#support-zip-modal input:checkbox:checked").length === 0) {
          checkAllBoxes();
        }
      } else {
        this.checked = true;
        $attachSupportZipDialog.show();
        submitAnalytics("stp.get.help.attach.dialog.shown");
      }
    });
  };
