/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import com.atlassian.crowd.manager.mail.EmailMessage;
import com.atlassian.crowd.manager.mail.HtmlEmailMessage;
import com.atlassian.crowd.manager.mail.MailConfigurationService;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.mail.TextEmailMessage;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.mail.AbstractMailUtility;
import com.atlassian.troubleshooting.stp.salext.mail.MailQueueItemFactory;
import com.atlassian.troubleshooting.stp.salext.mail.MailServerManagerProvider;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequest;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequestAttachment;
import jakarta.activation.FileDataSource;
import jakarta.annotation.Nonnull;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CrowdMailUtility
extends AbstractMailUtility {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdMailUtility.class);
    private final MailManager mailManager;
    private final MailConfigurationService mailConfigurationService;

    @Autowired
    public CrowdMailUtility(@Nonnull MailManager mailManager, @Nonnull @Qualifier(value="mailConfigurationService") MailConfigurationService mailConfigurationService, @Nonnull MailQueueItemFactory mailQueueItemFactory, @Nonnull MailServerManagerProvider factoryProvider) {
        super(mailQueueItemFactory, factoryProvider);
        this.mailManager = Objects.requireNonNull(mailManager);
        this.mailConfigurationService = Objects.requireNonNull(mailConfigurationService);
    }

    @Override
    public String getDefaultFromAddress() {
        return "noreply@atlassian.com";
    }

    @Override
    public boolean isMailServerConfigured() {
        return this.mailConfigurationService.isConfigured();
    }

    @Override
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException {
        try {
            HashMap<String, Object> attachmentSources = new HashMap<String, Object>();
            block7: for (SupportRequestAttachment attachment : requestInfo.getAttachments()) {
                Serializable data;
                Serializable serializable = data = attachment.getData();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, String.class, File.class}, (Object)serializable, n)) {
                    case 0: {
                        byte[] bytes = (byte[])serializable;
                        attachmentSources.put(attachment.getName(), new ByteArrayDataSource(bytes, attachment.getType()));
                        continue block7;
                    }
                    case 1: {
                        String s = (String)((Object)serializable);
                        attachmentSources.put(attachment.getName(), new ByteArrayDataSource(s.getBytes(), attachment.getType()));
                        continue block7;
                    }
                    case 2: {
                        File file = (File)serializable;
                        attachmentSources.put(attachment.getName(), new FileDataSource(file));
                        continue block7;
                    }
                }
                LOG.debug("Attachment [{}], of declared type [{}], contains unexpected data: '{}'. It will not be added to the mail message", (Object[])new String[]{attachment.getName(), attachment.getType(), data == null ? "(Null)" : data.getClass().getName()});
            }
            Iterable<Map.Entry<String, String>> headerEntries = requestInfo.getHeaders();
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : headerEntries) {
                headerMap.put(entry.getKey(), entry.getValue());
            }
            this.mailManager.sendEmail((EmailMessage)TextEmailMessage.builder().setTo(List.of(new InternetAddress(requestInfo.getToAddress()))).setSubject(requestInfo.getSubject()).setBody(requestInfo.getBody()).setHeaders(headerMap).setAttachments(attachmentSources).build());
        }
        catch (MailSendException e) {
            throw new MailException(e.getCause());
        }
    }

    @Override
    public void sendMail(Email email) {
        if (this.isMailServerConfigured()) {
            try {
                if (email.getMimeType().equals("text/html")) {
                    this.mailManager.sendEmail((EmailMessage)HtmlEmailMessage.builder().setTo(List.of(new InternetAddress(email.getTo()))).setSubject(email.getSubject()).setBody(email.getBody()).build());
                }
                this.mailManager.sendEmail((EmailMessage)TextEmailMessage.builder().setTo(List.of(new InternetAddress(email.getTo()))).setSubject(email.getSubject()).setBody(email.getBody()).setHeaders(email.getHeaders()).build());
            }
            catch (MailSendException | AddressException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            LOG.warn("Unable to send mail as mail server is not configured.");
        }
    }
}

