/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.ihs;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.troubleshooting.stp.action.AbstractSupportToolsAction;
import com.atlassian.troubleshooting.stp.action.SupportToolsAction;
import com.atlassian.troubleshooting.stp.salext.ApplicationType;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class InstanceHealthScoreAction
extends AbstractSupportToolsAction {
    public static final String IHS_DISABLED_FEATURE_KEY = "com.atlassian.troubleshooting.ihs.disabled";
    public static final String IHS_ENABLED_FEATURE_KEY = "com.atlassian.troubleshooting.ihs.enabled";
    public static final String ACTION_NAME = "instance-health-score";
    private static final List<ApplicationType> SUPPORTED_APPS = ImmutableList.of((Object)((Object)ApplicationType.JIRA), (Object)((Object)ApplicationType.CONFLUENCE));
    private final SupportApplicationInfo applicationInfo;
    private final DarkFeatureManager darkFeatureManager;

    public InstanceHealthScoreAction(SupportApplicationInfo applicationInfo, DarkFeatureManager darkFeatureManager) {
        super(ACTION_NAME, "stp.troubleshooting.title", "stp.ihs.tab.title", null);
        this.applicationInfo = applicationInfo;
        this.darkFeatureManager = darkFeatureManager;
    }

    public static boolean isAvailable(ApplicationType applicationType) {
        return SUPPORTED_APPS.contains((Object)applicationType);
    }

    @Override
    public boolean isEnabled() {
        boolean isExplicitlyDisabled = this.darkFeatureManager.isEnabledForAllUsers(IHS_DISABLED_FEATURE_KEY).orElse(false);
        if (isExplicitlyDisabled) {
            return false;
        }
        boolean isExplicitlyEnabled = this.darkFeatureManager.isEnabledForAllUsers(IHS_ENABLED_FEATURE_KEY).orElse(false);
        if (isExplicitlyEnabled) {
            return true;
        }
        return this.isTabEnabledByDefault();
    }

    @Override
    @Nonnull
    public SupportToolsAction newInstance() {
        return new InstanceHealthScoreAction(this.applicationInfo, this.darkFeatureManager);
    }

    boolean isTabEnabledByDefault() {
        ApplicationType applicationType = this.applicationInfo.getApplicationType();
        if (ApplicationType.JIRA == applicationType) {
            return true;
        }
        if (ApplicationType.CONFLUENCE == applicationType) {
            return false;
        }
        return false;
    }
}

