/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.checks.clientcredentials;

import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientService {
    private static final Logger LOG = LoggerFactory.getLogger(ClientService.class);
    private static final String SOON_TO_EXPIRE_PROPERTY_KEY = "troubleshooting.healthcheck.client.credentials.soon.to.expire.in.days";
    private static final int DEFAULT_SOON_TO_EXPIRE_IN_DAYS = 14;
    private final ClientExpirationEvaluator clientExpirationEvaluator;

    public ClientService(ClientExpirationEvaluator clientExpirationEvaluator) {
        this.clientExpirationEvaluator = clientExpirationEvaluator;
    }

    public long getTotalClientsCount(List<Client> clientList, Set<String> givenClientIds) {
        return clientList.stream().filter(client -> this.isSpecificClient((Client)client, givenClientIds)).count();
    }

    public long getSoonToExpireClientsCount(List<Client> clientList, Set<String> givenClientIds, Set<Client> expiredClients) {
        return clientList.stream().filter(client -> this.isSpecificClient((Client)client, givenClientIds) && this.isClientNotExpired(expiredClients, (Client)client) && this.clientExpirationEvaluator.hasSoonToExpireLimitBreached(client, this.getSoonToExpireThreshold())).count();
    }

    public Set<Client> getExpiredClients(List<Client> clientList, Set<String> givenClientIds) {
        return clientList.stream().filter(client -> this.isSpecificClient((Client)client, givenClientIds) && this.clientExpirationEvaluator.hasExpireLimitBreached(client)).collect(Collectors.toSet());
    }

    protected boolean isSpecificClient(Client client, Set<String> givenClientIds) {
        return givenClientIds.contains(client.getId());
    }

    private boolean isClientNotExpired(Set<Client> expiredClients, Client client) {
        return !expiredClients.contains(client);
    }

    public long getMinimumExpiryDurationInDays(List<Client> clientList, Set<String> givenClientIds) {
        long minExpiryInSeconds = clientList.stream().filter(client -> givenClientIds.contains(client.getId()) && client.getExpiryDuration() != null).map(Client::getExpiryDuration).reduce(this.clientExpirationEvaluator.getDefaultClientCredentialExpiry(), Math::min);
        return Duration.ofSeconds(minExpiryInSeconds).toDays();
    }

    private Duration getSoonToExpireThreshold() {
        String soonToExpireProp = System.getProperty(SOON_TO_EXPIRE_PROPERTY_KEY);
        try {
            int soonToExpireInDays = soonToExpireProp != null ? Integer.parseInt(soonToExpireProp) : 14;
            return Duration.ofDays(soonToExpireInDays);
        }
        catch (NumberFormatException e) {
            LOG.error("Invalid number format for '{}': {}", (Object)SOON_TO_EXPIRE_PROPERTY_KEY, (Object)soonToExpireProp);
            return Duration.ofDays(14L);
        }
    }
}

