// On Document Load:
AJS.$(document).ready(function () {
    "use strict";

    var isGetHelp = true;

    // When the tab is loaded, do our magic:
    AJS.bind("troubleshootingTabLoaded#create-support-request troubleshootingTabUpdated#create-support-request", function (e, data) {

        // determine which content to show based on state of the click handler.
        AJS.$('#get-help').toggle(isGetHelp);
        AJS.$('#raise-support-request').toggle(!isGetHelp);

        // Register our click handlers:
        var clickHandler = function () {
            AJS.$('#get-help').toggle();
            AJS.$('#raise-support-request').toggle();
            isGetHelp = !isGetHelp
        };

        AJS.$('#technical-support button').on('click', clickHandler);
        AJS.$('#raise-support-request a.goBackLink').on('click', clickHandler);

        // Analytics Binding for things inside the tab:
        AJS.$('#how-to-link').click(function (e) {
            AJS.trigger('analyticsEvent', {name: 'stp.get.help.howto'});
        });
        AJS.$('#troubleshooting-link').click(function (e) {
            AJS.trigger('analyticsEvent', {name: 'stp.get.help.troubleshooting'});
        });
        AJS.$('#community-link').click(function (e) {
            AJS.trigger('analyticsEvent', {name: 'stp.get.help.community'});
        });
        AJS.$('#purchasing-link').click(function (e) {
            AJS.trigger('analyticsEvent', {name: 'stp.get.help.purchasing'});
        });
        AJS.$('#product-feedback-link').click(function (e) {
            AJS.trigger('analyticsEvent', {name: 'stp.get.help.feedback'});
        });
        AJS.$('#contact-technical-support').click(function (e) {
            AJS.trigger('analyticsEvent', {name: 'stp.get.help.ticketform'});
        });

        // Determine which product we're using:
        var myProduct = AJS.$('#stp-application-name').prop('value').toString().toLowerCase();

        // Create the links:
        AJS.$('#how-to a').attr('href', createLink(myProduct, 'documentation'));
        AJS.$('#troubleshooting a').attr('href', createLink(myProduct, 'kb'));
        AJS.$('#community a').attr('href', createLink(myProduct, 'answers'));
        AJS.$('#product-feedback a').attr('href', createLink(myProduct, 'jac'));
    });
});

function createLink(product, linkType) {
    // This product creates a link type based on the product:
    var destinations = {
        bamboo: {
            docSpace: 'bamboo',
            kbSpace: 'bamkb',
            aacID: 753705,
            cacTag: 'bamboo',
            jacID: 11011,
            newFeatureID: 2
        },
        confluence: {
            docSpace: 'doc',
            kbSpace: 'confkb',
            aacID: 753687,
            cacTag: 'confluence',
            jacID: 10470,
            newFeatureID: 10000
        },
        crowd: {
            docSpace: 'display/crowd',
            kbSpace: 'crowdkb',
            aacID: 753712,
            cacTag: 'crowd',
            jacID: 11291,
            newFeatureID: 2
        },
        stash: {
            docSpace: 'bitbucketserver',
            kbSpace: 'bitbucketserverkb',
            aacID: 753750,
            cacTag: 'bitbucket',
            jacID: 13310,
            newFeatureID: 10000
        },
        bitbucket: {
            docSpace: 'bitbucketserver',
            kbSpace: 'bitbucketserverkb',
            aacID: 753750,
            cacTag: 'bitbucket',
            jacID: 13310,
            newFeatureID: 10000
        },
        jira: {
            docSpace: 'jira',
            kbSpace: 'jirakb',
            aacID: 753669,
            cacTag: 'jira',
            jacID: 10240,
            newFeatureID: 10000
        }
    };

    // Basic links:
    var doc = 'https://confluence.atlassian.com/';
    var kb = 'https://confluence.atlassian.com/';
    var cac = 'https://community.atlassian.com/';
    var jac = 'https://jira.atlassian.com/secure/CreateIssue.jspa';

    switch (linkType) {
        case 'documentation':
            return (destinations[product] === undefined) ? doc : AJS.format(doc + '{0}', destinations[product].docSpace);
            break;

        case 'kb':
            return (destinations[product] === undefined) ? kb : AJS.format(kb + '{0}', destinations[product].kbSpace);
            break;

        case 'answers':
            // Simply appending the product does not work for all products.
            // Concatenated path has been taken directly from the ticket (https://bulldog.internal.atlassian.com/browse/XPLN-242).
            return (destinations[product] === undefined) ? cac : AJS.format(cac + 't5/{0}/ct-p/{0}', destinations[product].cacTag);
            break;

        case 'jac':
            return (destinations[product] === undefined) ? jac : AJS.format(jac + '?pid={0}&issuetype={1}', destinations[product].jacID, destinations[product].newFeatureID);
            break;
    }
}
