/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.troubleshooting.stp.salext.SupportApplicationInfo;
import com.atlassian.troubleshooting.stp.salext.mail.AbstractMailUtility;
import com.atlassian.troubleshooting.stp.salext.mail.MailQueueItemFactory;
import com.atlassian.troubleshooting.stp.salext.mail.MailServerManagerProvider;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequest;
import com.atlassian.troubleshooting.stp.salext.mail.SupportRequestAttachment;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.activation.FileDataSource;
import javax.annotation.Nonnull;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.util.ByteArrayDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdMailUtility
extends AbstractMailUtility {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdMailUtility.class);
    private final MailManager mailManager;

    @Autowired
    public CrowdMailUtility(@Nonnull MailManager mailManager, @Nonnull MailQueueItemFactory mailQueueItemFactory, @Nonnull MailServerManagerProvider factoryProvider) {
        super(mailQueueItemFactory, factoryProvider);
        this.mailManager = Objects.requireNonNull(mailManager);
    }

    @Override
    public String getDefaultFromAddress() {
        return "noreply@atlassian.com";
    }

    @Override
    public boolean isMailServerConfigured() {
        return this.mailManager.isConfigured();
    }

    @Override
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException {
        try {
            HashMap<String, Object> attachmentSources = new HashMap<String, Object>();
            for (SupportRequestAttachment attachment : requestInfo.getAttachments()) {
                Serializable data = attachment.getData();
                if (data instanceof byte[]) {
                    attachmentSources.put(attachment.getName(), new ByteArrayDataSource((byte[])data, attachment.getType()));
                    continue;
                }
                if (data instanceof String) {
                    attachmentSources.put(attachment.getName(), new ByteArrayDataSource(((String)((Object)data)).getBytes(), attachment.getType()));
                    continue;
                }
                if (data instanceof File) {
                    attachmentSources.put(attachment.getName(), new FileDataSource((File)data));
                    continue;
                }
                LOG.debug("Attachment [{}], of declared type [{}], contains unexpected data: '{}'. It will not be added to the mail message", (Object[])new String[]{attachment.getName(), attachment.getType(), data == null ? "(Null)" : data.getClass().getName()});
            }
            Iterable<Map.Entry<String, String>> headerEntries = requestInfo.getHeaders();
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : headerEntries) {
                headerMap.put(entry.getKey(), entry.getValue());
            }
            this.mailManager.sendPlainTextEmail(new InternetAddress(requestInfo.getToAddress()), requestInfo.getSubject(), requestInfo.getBody(), headerMap, attachmentSources);
        }
        catch (MailSendException e) {
            throw new MailException(e.getCause());
        }
    }

    @Override
    public void sendMail(Email email) {
        if (this.isMailServerConfigured()) {
            try {
                if (email.getMimeType().equals("text/html")) {
                    this.mailManager.sendHtmlEmail(new InternetAddress(email.getTo()), email.getSubject(), email.getBody(), email.getBody());
                }
                this.mailManager.sendPlainTextEmail(new InternetAddress(email.getTo()), email.getSubject(), email.getBody(), email.getHeaders(), null);
            }
            catch (MailSendException | AddressException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            LOG.warn("Unable to send mail as mail server is not configured.");
        }
    }
}

