/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.service;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.troubleshooting.api.healthcheck.ExtendedSupportHealthCheck;
import com.atlassian.troubleshooting.api.healthcheck.SupportHealthCheckSupplier;
import com.atlassian.troubleshooting.api.healthcheck.exception.SupportHealthCheckModuleDescriptorNotFoundException;
import com.atlassian.troubleshooting.healthcheck.model.InvalidLicenseUserLimitException;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitCheckType;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.persistence.LicenseUserLimitConfigurationStore;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractLicenseUserLimitService
implements LicenseUserLimitService {
    private final DarkFeatureManager darkFeatureManager;
    private final LicenseUserLimitConfigurationStore licenseUserLimitConfigurationStore;
    private final SupportHealthCheckSupplier supportHealthCheckSupplier;

    protected AbstractLicenseUserLimitService(DarkFeatureManager darkFeatureManager, LicenseUserLimitConfigurationStore licenseUserLimitConfigurationStore, SupportHealthCheckSupplier supportHealthCheckSupplier) {
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
        this.licenseUserLimitConfigurationStore = Objects.requireNonNull(licenseUserLimitConfigurationStore);
        this.supportHealthCheckSupplier = Objects.requireNonNull(supportHealthCheckSupplier);
    }

    @Override
    public LicenseUserLimitConfiguration getLicenseUserLimitConfig() {
        return this.licenseUserLimitConfigurationStore.getConfiguration(this.getCheckType());
    }

    @Override
    public void setLicenseUserLimitConfig(LicenseUserLimitConfiguration licenseUserLimitConfiguration) throws InvalidLicenseUserLimitException {
        Objects.requireNonNull(licenseUserLimitConfiguration, "licenseUserLimitConfiguration cannot be null");
        if (licenseUserLimitConfiguration.getLimit() < 0) {
            throw new InvalidLicenseUserLimitException("License user limit can not be negative");
        }
        if (licenseUserLimitConfiguration.getIsPercentage() && licenseUserLimitConfiguration.getLimit() > 100) {
            throw new InvalidLicenseUserLimitException("License user limit must be less than or equal to 100 if it is percentage");
        }
        this.licenseUserLimitConfigurationStore.storeConfiguration(this.getCheckType(), licenseUserLimitConfiguration);
    }

    protected abstract LicenseUserLimitCheckType getCheckType();

    private boolean isFeatureFlagEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers("com.atlassian.troubleshooting.healthcheck.license.limit.healthcheck.ui").orElse(false);
    }

    private boolean isHealthCheckEnabled() {
        Optional<ExtendedSupportHealthCheck> healthCheck;
        try {
            healthCheck = this.supportHealthCheckSupplier.getHealthCheck(this.getCheckType().getCompleteHealthCheckKey());
        }
        catch (SupportHealthCheckModuleDescriptorNotFoundException e) {
            return false;
        }
        return healthCheck.isPresent() && !healthCheck.get().isSoftLaunch();
    }

    @Override
    public boolean isConfigurable() {
        return this.isFeatureFlagEnabled() && this.isHealthCheckEnabled();
    }
}

