/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.data;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitCheckType;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUserLimitDataProvider
implements WebResourceDataProvider {
    private static final String EMPTY_RESPONSE = "{}";
    private static final Logger LOG = LoggerFactory.getLogger(LicenseUserLimitDataProvider.class);
    private final Map<LicenseUserLimitCheckType, LicenseUserLimitService> licenseUserLimitServices;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final UserManager userManager;

    public LicenseUserLimitDataProvider(Map<LicenseUserLimitCheckType, LicenseUserLimitService> licenseUserLimitServices, UserManager userManager) {
        this.licenseUserLimitServices = Objects.requireNonNull(licenseUserLimitServices);
        this.licenseUserLimitServices.values().forEach(Objects::requireNonNull);
        this.userManager = userManager;
    }

    public Jsonable get() {
        if (!this.isUserSysAdmin()) {
            return writer -> writer.write(EMPTY_RESPONSE);
        }
        try {
            Map<String, LicenseUserLimitConfiguration> configForEnabledChecks = this.licenseUserLimitServices.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<LicenseUserLimitCheckType, Optional<LicenseUserLimitConfiguration>>((LicenseUserLimitCheckType)((Object)((Object)entry.getKey())), this.getLicenseUserLimitConfigIfConfigurable((LicenseUserLimitService)entry.getValue()))).filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(entry -> ((LicenseUserLimitCheckType)((Object)((Object)entry.getKey()))).getKey(), entry -> (LicenseUserLimitConfiguration)((Optional)entry.getValue()).get()));
            String configurationJson = this.objectMapper.writeValueAsString(configForEnabledChecks);
            return writer -> writer.write(configurationJson);
        }
        catch (Exception e) {
            LOG.error("Unable to serialise license limit config WRM data", (Throwable)e);
            return writer -> writer.write(EMPTY_RESPONSE);
        }
    }

    private boolean isUserSysAdmin() {
        return this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey());
    }

    private Optional<LicenseUserLimitConfiguration> getLicenseUserLimitConfigIfConfigurable(@Nonnull LicenseUserLimitService service) {
        return service.isConfigurable() ? Optional.of(service.getLicenseUserLimitConfig()) : Optional.empty();
    }
}

