/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.salext.bundle;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.healthcheck.DatabaseService;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.api.supportzip.TempFileSupportZipArtifact;
import java.io.CharArrayWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DatabaseQueriesBundle
implements SupportZipBundle {
    private static final String TITLE_KEY = "stp.zip.include.database.queries";
    private static final String DESCRIPTION_KEY = "stp.zip.include.database.queries.description";
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseQueriesBundle.class);
    private final DatabaseService databaseService;
    private final I18nResolver i18nResolver;

    @Autowired
    public DatabaseQueriesBundle(DatabaseService databaseService, I18nResolver i18nResolver) {
        this.databaseService = databaseService;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public String getTitle() {
        return this.i18nResolver.getText(TITLE_KEY);
    }

    @Override
    public String getDescription() {
        return this.i18nResolver.getText(DESCRIPTION_KEY);
    }

    protected SupportZipBundle.Artifact csvArtifact(String fileName, String query) {
        return this.databaseService.runInConnection(c -> {
            CharArrayWriter writer = new CharArrayWriter();
            try (PreparedStatement statement = c.prepareStatement(query);
                 ResultSet resultSet = statement.executeQuery();){
                int i;
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (i = 1; i <= columnCount; ++i) {
                    writer.append(resultSet.getMetaData().getColumnLabel(i));
                    if (i >= columnCount) continue;
                    writer.append(',');
                }
                writer.append('\n');
                while (resultSet.next()) {
                    for (i = 1; i <= columnCount; ++i) {
                        String value = resultSet.getString(i);
                        if (value != null) {
                            value = value.replace("\"", "\"\"");
                        }
                        writer.append('\"').append(value == null ? "" : value).append('\"');
                        if (i >= columnCount) continue;
                        writer.append(',');
                    }
                    writer.append('\n');
                }
            }
            catch (SQLException e) {
                LOG.warn("Failed to execute query: {}", (Object)query, (Object)e);
                writer.append(String.format("Failed to execute query: %s", query));
            }
            return new TempFileSupportZipArtifact(writer.toString(), fileName, "");
        });
    }

    @Override
    public String getKey() {
        return "database-queries";
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

