/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.healthcheck.service;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.healthcheck.event.LicenseUserLimitConfigUpdateEvent;
import com.atlassian.troubleshooting.healthcheck.model.InvalidLicenseUserLimitException;
import com.atlassian.troubleshooting.healthcheck.model.LicenseUserLimitConfiguration;
import com.atlassian.troubleshooting.healthcheck.persistence.LicenseUserLimitConfigurationStore;
import com.atlassian.troubleshooting.healthcheck.service.LicenseUserLimitService;
import com.atlassian.troubleshooting.stp.audit.Auditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUserLimitServiceEventProxy
implements LicenseUserLimitService {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseUserLimitServiceEventProxy.class);
    private final Auditor auditor;
    private final LicenseUserLimitService delegate;
    private final EventPublisher eventPublisher;
    private final I18nResolver i18nResolver;
    private final LicenseUserLimitConfigurationStore.Product product;

    public LicenseUserLimitServiceEventProxy(LicenseUserLimitService delegate, EventPublisher eventPublisher, LicenseUserLimitConfigurationStore.Product product, Auditor auditor, I18nResolver i18nResolver) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.product = product;
        this.auditor = auditor;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public LicenseUserLimitConfiguration getLicenseUserLimitConfig() {
        return this.delegate.getLicenseUserLimitConfig();
    }

    @Override
    public void setLicenseUserLimitConfig(LicenseUserLimitConfiguration licenseUserLimitConfiguration) throws InvalidLicenseUserLimitException {
        Objects.requireNonNull(licenseUserLimitConfiguration, "licenseUserLimitConfiguration cannot be null");
        LicenseUserLimitConfiguration oldConfiguration = this.delegate.getLicenseUserLimitConfig();
        this.delegate.setLicenseUserLimitConfig(licenseUserLimitConfiguration);
        this.sendAuditLog(oldConfiguration, licenseUserLimitConfiguration);
        this.sendAnalyticsEvent(licenseUserLimitConfiguration);
    }

    private void sendAuditLog(LicenseUserLimitConfiguration oldConfiguration, LicenseUserLimitConfiguration newConfiguration) {
        List<Auditor.ChangedValue> changedValues = this.getChangedValues(oldConfiguration, newConfiguration);
        if (!changedValues.isEmpty()) {
            Map<String, String> unchangedValues = this.getUnchangedValues(oldConfiguration, newConfiguration);
            this.auditor.audit(String.format(this.product.getI18nKeyTemplate(), "configuration.changed.audit.summary"), unchangedValues, changedValues);
        }
    }

    private void sendAnalyticsEvent(LicenseUserLimitConfiguration licenseUserLimitConfiguration) {
        LOG.debug("sending analytics event for licenseUserLimitConfiguration update");
        this.eventPublisher.publish((Object)LicenseUserLimitConfigUpdateEvent.of(licenseUserLimitConfiguration, this.product));
    }

    private List<Auditor.ChangedValue> getChangedValues(LicenseUserLimitConfiguration oldConfiguration, LicenseUserLimitConfiguration newConfiguration) {
        ArrayList<Auditor.ChangedValue> changedValues = new ArrayList<Auditor.ChangedValue>();
        if (oldConfiguration.getLimit() != newConfiguration.getLimit()) {
            changedValues.add(new Auditor.ChangedValue("stp.license.user.limit.audit.limit.field.name", String.valueOf(oldConfiguration.getLimit()), String.valueOf(newConfiguration.getLimit())));
        }
        if (oldConfiguration.getIsPercentage() != newConfiguration.getIsPercentage()) {
            changedValues.add(new Auditor.ChangedValue("stp.license.user.limit.audit.limit.type.field.name", this.translateIsPercentage(oldConfiguration.getIsPercentage()), this.translateIsPercentage(newConfiguration.getIsPercentage())));
        }
        return changedValues;
    }

    private Map<String, String> getUnchangedValues(LicenseUserLimitConfiguration oldConfiguration, LicenseUserLimitConfiguration newConfiguration) {
        HashMap<String, String> unChangedValues = new HashMap<String, String>();
        if (oldConfiguration.getLimit() == newConfiguration.getLimit()) {
            unChangedValues.put("stp.license.user.limit.audit.limit.field.name", String.valueOf(newConfiguration.getLimit()));
        }
        if (oldConfiguration.getIsPercentage() == newConfiguration.getIsPercentage()) {
            unChangedValues.put("stp.license.user.limit.audit.limit.type.field.name", this.translateIsPercentage(newConfiguration.getIsPercentage()));
        }
        return unChangedValues;
    }

    private String translateIsPercentage(boolean isPercentage) {
        return isPercentage ? this.i18nResolver.getText("stp.license.user.limit.audit.limit.type.percentage") : this.i18nResolver.getText("stp.license.user.limit.audit.limit.type.number");
    }
}

