/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd;

import com.atlassian.crowd.service.cluster.ClusterMessageListener;
import com.atlassian.crowd.service.cluster.ClusterMessageService;
import com.atlassian.troubleshooting.crowd.Message;
import com.atlassian.troubleshooting.stp.util.ObjectMapperFactory;
import com.atlassian.troubleshooting.stp.zip.SupportZipService;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrowdClusteredSupportZipListener
implements ClusterMessageListener {
    private final SupportZipService supportZipService;

    @Autowired
    public CrowdClusteredSupportZipListener(ClusterMessageService clusterMessageService, SupportZipService supportZipService) {
        this.supportZipService = supportZipService;
        clusterMessageService.registerListener((ClusterMessageListener)this, "troubleshooting.support.zip");
    }

    public void handleMessage(String channel, String message) {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Message m = (Message)mapper.readValue(message, Message.class);
            m.handle(this.supportZipService);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }
}

