/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.stp.request;

import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.stp.request.SupportZipCreationRequest;
import com.atlassian.troubleshooting.stp.salext.mail.EmailValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;

public class SupportRequestCreationRequest {
    private final boolean limitFileSizes;
    private final int priority;
    private final List<SupportZipBundle> bundles;
    private final String description;
    private final String fromAddress;
    private final String subject;

    SupportRequestCreationRequest(Builder builder) {
        this.bundles = ImmutableList.copyOf((Collection)builder.bundles.build());
        this.description = Objects.requireNonNull(builder.description);
        this.fromAddress = Objects.requireNonNull(builder.fromAddress);
        this.limitFileSizes = builder.limitFileSizes;
        this.priority = builder.priority;
        this.subject = Objects.requireNonNull(builder.subject);
    }

    @Nonnull
    public List<SupportZipBundle> getBundles() {
        return this.bundles;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getFromAddress() {
        return this.fromAddress;
    }

    @Nonnull
    public String getSubject() {
        return this.subject;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isLimitFileSizes() {
        return this.limitFileSizes;
    }

    @Nonnull
    public SupportZipCreationRequest getSupportZipCreationRequest() {
        return new SupportZipCreationRequest(new SupportZipCreationRequest.Builder().limitFileSizes(this.limitFileSizes).bundles(this.bundles));
    }

    public static class Builder {
        private final ImmutableList.Builder<SupportZipBundle> bundles = ImmutableList.builder();
        private boolean limitFileSizes;
        private int priority;
        private String description;
        private String fromAddress;
        private String subject;

        @Nonnull
        public SupportRequestCreationRequest build() {
            return new SupportRequestCreationRequest(this);
        }

        public Builder description(@Nonnull String value) {
            this.description = value;
            return this;
        }

        public Builder fromAddress(@Nonnull String value) {
            Validate.notBlank((CharSequence)value, (String)"fromAddress is required", (Object[])new Object[0]);
            Preconditions.checkArgument((boolean)EmailValidator.isValidEmailAddress(value), (Object)"fromAddress is invalid");
            this.fromAddress = value;
            return this;
        }

        @Nonnull
        public Builder limitFileSizes(boolean value) {
            this.limitFileSizes = value;
            return this;
        }

        public Builder subject(@Nonnull String value) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)value), (Object)"subject is required");
            this.subject = value;
            return this;
        }

        public Builder priority(int value) {
            this.priority = value;
            return this;
        }

        public Builder bundles(@Nonnull Iterable<SupportZipBundle> bundles) {
            this.bundles.addAll(Objects.requireNonNull(bundles));
            return this;
        }
    }
}

