/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.troubleshooting.crowd.spring;

import com.atlassian.crowd.service.HomeDirectoryService;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.troubleshooting.api.supportzip.SupportZipBundle;
import com.atlassian.troubleshooting.spring.CommonSupportZipBundleBeans;
import com.atlassian.troubleshooting.spring.TomcatLogsSupportZipBundleBeans;
import com.atlassian.troubleshooting.stp.salext.bundle.BundleManifest;
import com.atlassian.troubleshooting.stp.salext.bundle.FileSetsBundle;
import com.atlassian.troubleshooting.stp.salext.bundle.fileset.ExactFileSet;
import com.atlassian.troubleshooting.stp.salext.bundle.fileset.RegexFileSet;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={TomcatLogsSupportZipBundleBeans.class})
public class CrowdSupportZipBundleBeans {
    private static final String ZIP_INCLUDE_CROWD_CFG_DESCRIPTION = "stp.zip.include.crowd.cfg.description";
    private static final String ZIP_INCLUDE_CROWD_CFG = "stp.zip.include.crowd.cfg";
    private static final String CROWD_CFG_XML_FILE = "crowd.cfg.xml";
    private static final String ZIP_INCLUDE_CROWD_LOG_DESCRIPTION = "stp.zip.include.crowd.log.description";
    private static final String ZIP_INCLUDE_CROWD_LOG = "stp.zip.include.crowd.log";
    private static final Pattern CROWD_LOG_FILE_PATTERN = Pattern.compile("^.*atlassian-crowd\\.log(\\.[1-9])?$");
    private static final Pattern TOMCAT_CONF_PATTERN = Pattern.compile("^.*.(xml|properties|policy)$");
    private static final String CONFIG_DIRECTORY_NAME = "conf";
    private final ApplicationProperties applicationProperties;
    private final ServletContextFactory servletContextFactory;

    public CrowdSupportZipBundleBeans(ApplicationProperties applicationProperties, ServletContextFactory servletContextFactory) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.servletContextFactory = Objects.requireNonNull(servletContextFactory);
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportApplicationConfigBundle(HomeDirectoryService homeDirectoryService, I18nResolver i18nResolver) {
        String pathToCrowdConfigFile = Optional.ofNullable(homeDirectoryService.getSharedHome()).orElse(this.getCrowdHomePath());
        String binDir = CommonSupportZipBundleBeans.findTomcatFileOrDirectory("bin");
        return this.export(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_CROWD_CFG, ZIP_INCLUDE_CROWD_CFG_DESCRIPTION, i18nResolver).fileSet(ExactFileSet.ofPaths(this.getWebInfClassesDir() + "/log4j.properties", binDir + "/setenv.sh", binDir + "/setenv.bat", binDir + "/setclasspath.sh", binDir + "/setclasspath.bat", binDir + "/startup.sh", binDir + "/startup.bat", binDir + "/shutdown.sh", binDir + "/shutdown.bat")).fileSet(ExactFileSet.ofPaths(pathToCrowdConfigFile + File.separator + CROWD_CFG_XML_FILE)).build());
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportCrowdLogsBundle(I18nResolver i18nResolver) {
        return this.export(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_CROWD_LOG, ZIP_INCLUDE_CROWD_LOG_DESCRIPTION, i18nResolver).fileSet(RegexFileSet.fromDirectoryPathRecursive(this.getCrowdHomePath(), CROWD_LOG_FILE_PATTERN)).build());
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportCrowdTomcatConfigBundle(I18nResolver i18nResolver) {
        String configDir = CommonSupportZipBundleBeans.findTomcatFileOrDirectory(CONFIG_DIRECTORY_NAME);
        if (StringUtils.isNotBlank((CharSequence)configDir)) {
            return this.export(FileSetsBundle.builder(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description", i18nResolver).fileSet(RegexFileSet.fromDirectoryPath(configDir, TOMCAT_CONF_PATTERN)).build());
        }
        return null;
    }

    private String getCrowdHomePath() {
        return this.applicationProperties.getHomeDirectory().toString();
    }

    private String getWebInfClassesDir() {
        return this.servletContextFactory.getServletContext().getRealPath("WEB-INF/classes");
    }

    private FactoryBean<ServiceRegistration> export(SupportZipBundle bundle) {
        return OsgiServices.exportOsgiService(bundle, ExportOptions.as(SupportZipBundle.class, new Class[0]));
    }
}

